/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HibernateProperties {
    private List<String> propertyFiles = new LinkedList<String>();
    private Properties properties = new Properties();

    public List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    public void setPropertyFiles(List<String> propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public void addPropertyFile(String file) {
        this.propertyFiles.add(file);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Properties buildProperties() {
        Properties props = new Properties();
        this.addPropertiesFromFiles(props);
        props.putAll((Map<?, ?>)this.getProperties());
        return props;
    }

    private void addPropertiesFromFiles(Properties props) {
        for (String file : this.propertyFiles) {
            Properties nProps = new Properties();
            try {
                InputStream stream = this.getClass().getResourceAsStream(file);
                if (stream == null) {
                    throw new IllegalArgumentException(file);
                }
                nProps.load(stream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            props.putAll((Map<?, ?>)nProps);
        }
    }
}

