/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import no.g9.dataaccess.usertype.ParameterizedType;

public class IntDate
implements ParameterizedType,
Serializable {
    private String dateFormat = "yyyyMMdd";
    private Date defaultValue = null;
    private SimpleDateFormat dateFormatter = null;

    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String defaultVal;
            if (parameters.get("default") != null && !(defaultVal = (String)parameters.get("default")).equals("null")) {
                this.defaultValue = this.fromInt(Integer.parseInt(defaultVal));
            }
            if (parameters.get("format") != null) {
                this.dateFormat = (String)parameters.get("format");
            }
        }
        this.dateFormatter = new SimpleDateFormat(this.dateFormat);
    }

    public synchronized Date fromInt(int value) {
        Date result = null;
        if (value != 0) {
            try {
                result = this.dateFormatter.parse(Integer.toString(value));
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
        return result;
    }

    public synchronized Integer fromDate(Date value) {
        if (value != null) {
            return new Integer(this.dateFormatter.format(value));
        }
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public SimpleDateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(SimpleDateFormat dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public Date getDefaultValue() {
        return this.defaultValue != null ? new Date(this.defaultValue.getTime()) : null;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = defaultValue != null ? new Date(defaultValue.getTime()) : null;
    }
}

