/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape;

import java.util.List;
import no.g9.dataaccess.Session;
import no.g9.jgrape.Manager;
import no.g9.jgrape.Role;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.ClientContext;
import no.g9.support.ObjectFactory;
import no.g9.support.ObjectSelection;
import no.g9.support.Registry;

public abstract class OsManager
implements Manager {
    private static final String OS_MANAGER = ".osmanager";
    private static final String OS_MANAGER_SUFFIX = "OsManager";
    Role targetRole = null;

    @Override
    public Object find(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.find(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.findAll(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object save(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.save(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object insert(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.insert(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object update(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.update(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object delete(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.delete(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object connect(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.connect(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object disconnect(ObjectSelection objectSelection, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.disconnect(objectSelection, ctx, session);
            }
        }
        return null;
    }

    @Override
    public Object get(ObjectSelection objectSelection, ENavigation navigation, ClientContext ctx, Session session) {
        Role rootRole = this.newManager(objectSelection.getApplicationName(), objectSelection.getCurrentRootName());
        if (rootRole != null) {
            rootRole.setCurrentObjectSelection(objectSelection);
            this.targetRole = rootRole.findRole(objectSelection.getTargetRoleName());
            if (this.targetRole != null) {
                return this.targetRole.get(objectSelection, navigation, ctx, session);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void cleanupResult(Object rootResult) {
        if (this.targetRole != null) {
            this.targetRole.cleanupResult(rootResult);
        }
    }

    @Override
    @Deprecated
    public void cleanupResult(Object rootResult, ClientContext ctx) {
        if (this.targetRole != null) {
            this.targetRole.cleanupResult(rootResult, ctx);
        }
    }

    @Override
    public void cleanupResult(Object rootResult, ClientContext ctx, Session session) {
        if (this.targetRole != null) {
            this.targetRole.cleanupResult(rootResult, ctx, session);
        }
    }

    @Override
    public void cleanupResultAssociations(Object rootResult, ClientContext ctx, Session session) {
        if (this.targetRole != null) {
            this.targetRole.cleanupResultAssociations(rootResult, ctx, session);
        }
    }

    public static Manager getManager(ObjectSelection objectSelection) {
        String managerName = OsManager.getManagerName(objectSelection);
        return (Manager)ObjectFactory.newObject((String)managerName);
    }

    private static String getManagerName(ObjectSelection objectSelection) {
        String propName;
        String managerName = null;
        String propFileName = objectSelection.getApplicationName() + OS_MANAGER;
        Registry reg = Registry.getRegistry();
        managerName = reg.getApplicationProperty(propFileName, propName = objectSelection.getObjectSelectionName());
        if (managerName == null) {
            String objectSelectionName = objectSelection.getObjectSelectionName().substring(0, 1).toUpperCase() + objectSelection.getObjectSelectionName().substring(1);
            propName = "ServiceApplication." + objectSelection.getApplicationName() + "." + "DefaultServicePackage";
            managerName = reg.getG9Property(propName) + "." + objectSelectionName.toLowerCase() + "." + objectSelectionName + OS_MANAGER_SUFFIX;
        }
        return managerName;
    }

    public static String createManagerClassName(String roleName, String pkgName) {
        return pkgName + "." + roleName.substring(0, 1).toUpperCase() + roleName.substring(1) + "Manager";
    }

    public abstract Role newManager(String var1, String var2);
}

