/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.trigger;

import java.util.ArrayList;
import java.util.List;
import no.esito.log.Logger;
import no.g9.jgrape.trigger.JGrapeTrigger;

final class TriggerFilter {
    private static Logger log = Logger.getLogger(TriggerFilter.class);

    private TriggerFilter() {
    }

    static List<JGrapeTrigger<?>> filter(List<JGrapeTrigger<?>> list, JGrapeTrigger.TriggerType filter) {
        log.trace((Object)("Filter: " + (Object)((Object)filter) + " list " + list));
        ArrayList filteredList = new ArrayList(list.size());
        for (JGrapeTrigger<?> jGrapeTrigger : list) {
            JGrapeTrigger.TriggerType actual = jGrapeTrigger.getTriggerType();
            if (!TriggerFilter.passFilter(actual, filter)) continue;
            filteredList.add(jGrapeTrigger);
        }
        log.trace((Object)("Done filtering : " + (Object)((Object)filter) + " result " + filteredList));
        return filteredList;
    }

    private static boolean passFilter(JGrapeTrigger.TriggerType actual, JGrapeTrigger.TriggerType filter) {
        switch (filter) {
            case DELETE: {
                return actual == JGrapeTrigger.TriggerType.DELETE || actual == JGrapeTrigger.TriggerType.ALL;
            }
            case INSERT: {
                return actual == JGrapeTrigger.TriggerType.INSERT || actual == JGrapeTrigger.TriggerType.ALL;
            }
            case UPDATE: {
                return actual == JGrapeTrigger.TriggerType.UPDATE || actual == JGrapeTrigger.TriggerType.ALL;
            }
            case SAVE: {
                return actual == JGrapeTrigger.TriggerType.SAVE || actual == JGrapeTrigger.TriggerType.INSERT || actual == JGrapeTrigger.TriggerType.ALL || actual == JGrapeTrigger.TriggerType.UPDATE;
            }
        }
        return true;
    }
}

