/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape;

import java.io.Serializable;
import java.util.List;
import no.g9.dataaccess.Session;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.EFindMethod;
import no.g9.support.FindData;

/**
 * The default implementation of the DataService interface.
 */
public class DataServiceImpl implements DataService {

    /**
     * An existing DataServiceImpl object
     */
    static private DataServiceImpl dataServiceImpl = null;

    /**
     * Get a DataServiceImpl object.
     *
     * @return either a new or an already existing DataServiceImpl object
     */
    static synchronized public DataServiceImpl getDataServiceImpl() {
        if (dataServiceImpl == null){
    	    dataServiceImpl = new DataServiceImpl();
	    }
	    return dataServiceImpl;
    }


    @Override
    public Object find(Class<?> clazz, Object key, FindData findData,
            Session session) {
        if (findData == null) {
            findData = new FindData(); // Using the DEFAULT findMethod
        }
        findData.setDomainClass(clazz);
        if (findData.getFindMethod().equals(EFindMethod.EXAMPLE)) {
            if (findData.getExample() == null) {
                findData.setExample(key);
            }
        } else if (findData.getFindMethod().equals(EFindMethod.DEFAULT)) {
            if (findData.getKey() == null) {
                findData.setKey((Serializable) key);
            }
        }
        return session.get(findData);
    }

    @Override
    public Object find(Class<?> clazz, Object key, List<String> keyAttributeNames,
            FindData findData, Session session) {
        if (findData == null) {
            findData = new FindData();
            findData.setFindMethod(EFindMethod.CRITERIA);
            findData.setCriterions(session.buildCriterionList(key, keyAttributeNames));
        }
        return this.find(clazz, key, findData, session);
    }

    @Override
    public Object find(FindData findData, Session session) {
        return session.get(findData);
    }

    @Override
    public List<?> findAll(Class<?> clazz, Object example, FindData findData,
            Session session) {
        if (findData == null) {
            findData = new FindData(); // Using the DEFAULT findMethod
        }
        findData.setDomainClass(clazz);
        if (findData.getFindMethod().equals(EFindMethod.EXAMPLE)) {
            if (findData.getExample() == null) {
                findData.setExample(example);
            }
        }
        return session.getAll(findData);
    }

    @Override
    public List<?> findAll(FindData findData, Session session) {
        return session.getAll(findData);
    }

    @Override
    public Serializable insert(Object object, Session session) {
        return session.insert(object);
    }

    @Override
    public void update(Object object, Session session) {
        session.update(object);
    }

    @Override
    public Object merge(Object object, Session session) {
        return session.merge(object);
    }

    @Override
    public void delete(Object object, Session session) {
        session.delete(object);
    }

    @Override
    public void delete(Object object, List<String> keyAttributes, Session session) {
        // Empty
    }

    @Override
    public Object get(Object currentObject, ENavigation navigation,
            Session session) {
        return null;
    }

    @Override
    public void findAssociated(Object object, Session session) {
        session.initialize(object);
    }

}
