/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import no.esito.log.Logger;
import no.g9.dataaccess.Session;
import no.g9.domain.DomainUtil;
import no.g9.exception.G9DataAccessException;
import no.g9.exception.G9ServiceException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.EFindMethod;
import no.g9.support.FindData;
import no.g9.support.FindOrder;
import no.g9.support.TypeTool;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SharedSessionContract;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.sql.JoinType;

public abstract class AbstractHibernateSession
implements Session {
    private Logger logger = Logger.getLogger(AbstractHibernateSession.class);

    @Override
    public Object get(FindData findData) throws G9DataAccessException {
        if (findData.getFindMethod().equals((Object)EFindMethod.QUERY)) {
            return this.query(findData, false);
        }
        if (findData.getFindMethod().equals((Object)EFindMethod.EXAMPLE)) {
            return this.qbe(findData, false);
        }
        if (findData.getFindMethod().equals((Object)EFindMethod.CRITERIA)) {
            return this.qbc(findData, false);
        }
        if (findData.getFindMethod().equals((Object)EFindMethod.DEFAULT)) {
            return this.simpleGet(findData);
        }
        return null;
    }

    @Override
    public List<?> getAll(FindData findData) throws G9DataAccessException {
        if (findData.getFindMethod().equals((Object)EFindMethod.QUERY)) {
            return (List)this.query(findData, true);
        }
        if (findData.getFindMethod().equals((Object)EFindMethod.EXAMPLE)) {
            return (List)this.qbe(findData, true);
        }
        if (findData.getFindMethod().equals((Object)EFindMethod.CRITERIA) || findData.getFindMethod().equals((Object)EFindMethod.DEFAULT)) {
            return (List)this.qbc(findData, true);
        }
        return null;
    }

    @Override
    public Serializable insert(Object object) throws G9DataAccessException {
        Serializable id = null;
        try {
            id = this.insertImpl(object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return id;
    }

    @Override
    public void update(Object object) throws G9DataAccessException {
        try {
            this.updateImpl(object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public Object merge(Object object) throws G9DataAccessException {
        try {
            return this.mergeImpl(object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void delete(Object object) throws G9DataAccessException {
        try {
            this.deleteImpl(object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public boolean isInitialized(Object object) {
        if (object instanceof HibernateProxy) {
            return !((HibernateProxy)object).getHibernateLazyInitializer().isUninitialized();
        }
        if (object instanceof PersistentCollection) {
            return ((PersistentCollection)object).wasInitialized();
        }
        return true;
    }

    @Override
    public void initialize(Object object) throws G9DataAccessException {
        try {
            Hibernate.initialize((Object)object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void refresh(Object object) throws G9DataAccessException {
        try {
            this.refreshImpl(object);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void close() throws G9DataAccessException {
        try {
            this.closeImpl();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void flush() throws G9DataAccessException {
        try {
            this.flushImpl();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void beginTransaction() throws G9DataAccessException {
        try {
            this.beginTransactionImpl();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void commitTransaction() throws G9DataAccessException {
        try {
            this.getSession().getTransaction().commit();
        }
        catch (StaleStateException e) {
            Object[] args = null;
            if (e instanceof StaleObjectStateException) {
                args = new Object[]{((StaleObjectStateException)e).getEntityName()};
            }
            Message msg = MessageSystem.getMessageFactory().getMessage("-1309", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ServiceException(msg);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.getSession().getTransaction().rollback();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Caught exception while trying to rollback transaction", (Throwable)e);
        }
    }

    @Override
    public boolean canRollbackTransaction() {
        try {
            return this.getSession().getTransaction().getStatus().canRollback();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Caught exception while checking if transaction can be rolled back", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasActiveTransaction() throws G9DataAccessException {
        try {
            return this.hasActiveTransactionImpl();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
    }

    public abstract SharedSessionContract getSession();

    protected Object query(FindData findData, boolean all) throws G9DataAccessException {
        Object result = null;
        try {
            Query query = this.buildQuery(findData.getQuery(), findData.getQueryParameters(), findData.getUseJpaPositionalParameters());
            this.applyFindData(query, findData);
            result = all ? query.list() : query.setMaxResults(1).uniqueResult();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return result;
    }

    private Query buildQuery(String queryString, List<Object> parameters, boolean jpaStyle) {
        Query query = this.buildQueryImpl(queryString);
        if (parameters != null) {
            Iterator<Object> iterator = parameters.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                if (jpaStyle) {
                    query.setParameter(String.valueOf(i + 1), iterator.next());
                } else {
                    query.setParameter(i, iterator.next());
                }
                ++i;
            }
        }
        return query;
    }

    @Override
    public String buildQueryString(Class<?> clazz, List<String> keyAttributeNames) {
        StringBuffer query = new StringBuffer("from ");
        query.append(clazz.getName());
        if (keyAttributeNames != null) {
            query.append(" q where");
            Iterator<String> iterator = keyAttributeNames.iterator();
            while (iterator.hasNext()) {
                String attributeName = iterator.next();
                query.append(" q.");
                query.append(attributeName);
                query.append(" = ?");
                if (!iterator.hasNext()) continue;
                query.append(" and");
            }
        }
        return query.toString();
    }

    @Override
    public List<Object> buildQueryParameterValueList(Object key, List<String> keyAttributeNames) {
        LinkedList<Object> params = null;
        if (keyAttributeNames != null) {
            params = new LinkedList<Object>();
            Class clazz = DomainUtil.getDomainClass((Object)key);
            Iterator<String> iterator = keyAttributeNames.iterator();
            String attributeName = null;
            try {
                while (iterator.hasNext()) {
                    attributeName = iterator.next();
                    Method method = clazz.getMethod(TypeTool.asBeanGetter((String)attributeName), null);
                    method.setAccessible(true);
                    params.add(method.invoke(key, (Object[])null));
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{attributeName};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1202", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9DataAccessException((Throwable)e, msg);
            }
        }
        return params;
    }

    @Override
    public List<Object> buildCriterionList(Object key, List<String> keyAttributeNames) {
        LinkedList<Object> criterions = new LinkedList<Object>();
        if (keyAttributeNames != null) {
            List<Object> values = this.buildQueryParameterValueList(key, keyAttributeNames);
            Iterator<String> nameIter = keyAttributeNames.iterator();
            Iterator<Object> valueIter = values.iterator();
            while (nameIter.hasNext()) {
                criterions.add(Restrictions.eq((String)nameIter.next(), (Object)valueIter.next()));
            }
        }
        return criterions;
    }

    protected Criteria applyFindDataProjection(Criteria criteria, FindData findData) {
        Object projection;
        if (findData != null && (projection = findData.getCriteriaProjection()) != null && projection instanceof Projection) {
            criteria.setProjection((Projection)projection);
        }
        return criteria;
    }

    protected Criteria applyFindDataAlias(Criteria criteria, FindData findData) {
        if (findData != null && findData.getCriterionAliases() != null) {
            for (String associationPath : findData.getCriterionAliases().keySet()) {
                String alias = (String)findData.getCriterionAliases().get(associationPath);
                JoinType joinType = (JoinType)findData.getCriterionJoinTypes().get(associationPath);
                Criterion withClause = (Criterion)findData.getCriterionWithClauses().get(associationPath);
                if (joinType != null && withClause != null) {
                    criteria.createAlias(associationPath, alias, joinType, withClause);
                    continue;
                }
                if (joinType != null) {
                    criteria.createAlias(associationPath, alias, joinType);
                    continue;
                }
                criteria.createAlias(associationPath, alias);
            }
        }
        return criteria;
    }

    protected Criteria applyFindData(Criteria criteria, FindData findData) {
        if (findData != null) {
            if (findData.getMaxResults() > 0) {
                criteria.setMaxResults(findData.getMaxResults());
            }
            if (findData.getFirstResult() > 0) {
                criteria.setFirstResult(findData.getFirstResult());
            }
            if (findData.getOrder() != null) {
                for (FindOrder findOrder : findData.getOrder()) {
                    Order order;
                    Order order2 = order = findOrder.getAscending() ? Order.asc((String)findOrder.getPropertyName()) : Order.desc((String)findOrder.getPropertyName());
                    if (findOrder.getIgnoreCase()) {
                        order = order.ignoreCase();
                    }
                    criteria.addOrder(order);
                }
            }
        }
        return criteria;
    }

    protected Query applyFindData(Query query, FindData findData) {
        if (findData != null) {
            if (findData.getMaxResults() > 0) {
                query.setMaxResults(findData.getMaxResults());
            }
            if (findData.getFirstResult() > 0) {
                query.setFirstResult(findData.getFirstResult());
            }
        }
        return query;
    }

    protected Object simpleGet(FindData findData) throws G9DataAccessException {
        Object result = null;
        try {
            result = this.simpleGetImpl(findData);
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return result;
    }

    protected Object qbe(FindData findData, boolean all) throws G9DataAccessException {
        Object result = null;
        try {
            Criteria criteria = this.createCriteriaImpl(findData);
            criteria.add((Criterion)Example.create((Object)findData.getExample()));
            this.applyFindData(criteria, findData);
            result = all ? criteria.list() : criteria.setMaxResults(1).uniqueResult();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return result;
    }

    protected Object qbc(FindData findData, boolean all) throws G9DataAccessException {
        Object result = null;
        try {
            Criteria criteria = this.createCriteriaImpl(findData);
            this.applyFindDataAlias(criteria, findData);
            this.applyFindDataProjection(criteria, findData);
            for (Object criterion : findData.getCriterions()) {
                if (!(criterion instanceof Criterion)) continue;
                criteria.add((Criterion)criterion);
            }
            this.applyFindData(criteria, findData);
            result = all ? criteria.list() : criteria.setMaxResults(1).uniqueResult();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return result;
    }

    protected abstract Object simpleGetImpl(FindData var1);

    protected abstract Criteria createCriteriaImpl(FindData var1);

    protected abstract Serializable insertImpl(Object var1);

    protected abstract void updateImpl(Object var1);

    protected abstract Object mergeImpl(Object var1);

    protected abstract void deleteImpl(Object var1);

    protected abstract void refreshImpl(Object var1);

    protected abstract void closeImpl();

    protected abstract void flushImpl();

    protected abstract Transaction beginTransactionImpl();

    protected abstract boolean hasActiveTransactionImpl();

    protected abstract Query buildQueryImpl(String var1);
}

