/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess;

import java.io.Serializable;
import no.g9.dataaccess.AbstractHibernateSession;
import no.g9.support.FindData;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class HibernateSession
extends AbstractHibernateSession {
    protected Session session;

    public HibernateSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean hasLockFlag(Class<?> domainClass) {
        ClassMetadata cm = this.getSession().getSessionFactory().getClassMetadata(domainClass);
        if (cm == null) {
            throw new IllegalArgumentException("Class " + domainClass + " is unknown to Hibernate");
        }
        return cm.isVersioned();
    }

    @Override
    protected Object simpleGetImpl(FindData findData) {
        return this.session.get(findData.getDomainClass(), findData.getKey());
    }

    @Override
    protected Criteria createCriteriaImpl(FindData findData) {
        return this.session.createCriteria(findData.getDomainClass());
    }

    @Override
    protected Serializable insertImpl(Object object) {
        return this.session.save(object);
    }

    @Override
    protected void updateImpl(Object object) {
        this.session.update(object);
    }

    @Override
    protected Object mergeImpl(Object object) {
        return this.session.merge(object);
    }

    @Override
    protected void deleteImpl(Object object) {
        this.session.delete(object);
    }

    @Override
    protected void refreshImpl(Object object) {
        this.session.refresh(object);
    }

    @Override
    protected void closeImpl() {
        if (this.session.isOpen()) {
            this.session.close();
        }
    }

    @Override
    protected void flushImpl() {
        this.session.flush();
    }

    @Override
    protected Transaction beginTransactionImpl() {
        return this.session.beginTransaction();
    }

    @Override
    protected boolean hasActiveTransactionImpl() {
        return this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE;
    }

    @Override
    protected Query buildQueryImpl(String queryString) {
        return this.session.createQuery(queryString);
    }
}

