/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.EnhancedUserType;

public class PersistentLocalDate
implements EnhancedUserType,
Serializable {
    private static final int[] SQL_TYPES = new int[]{93};

    public int[] sqlTypes() {
        return (int[])SQL_TYPES.clone();
    }

    public Class<LocalDate> returnedClass() {
        return LocalDate.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        LocalDate dtx = (LocalDate)x;
        LocalDate dty = (LocalDate)y;
        return dtx.equals(dty);
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, strings[0], session);
    }

    private Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor session) throws SQLException {
        Object date = StandardBasicTypes.DATE.nullSafeGet(resultSet, string, session);
        if (date == null) {
            return null;
        }
        Date d = (Date)date;
        Instant instant = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            StandardBasicTypes.DATE.nullSafeSet(preparedStatement, null, index, session);
        } else {
            LocalDate ld = (LocalDate)value;
            Instant instant = ld.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Date d = new Date(instant.toEpochMilli());
            StandardBasicTypes.DATE.nullSafeSet(preparedStatement, (Object)d, index, session);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object value) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public String objectToSQLString(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toXMLString(Object object) {
        return object.toString();
    }

    public Object fromXMLString(String string) {
        return LocalDate.parse(string);
    }
}

