/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape;

import java.util.List;
import no.esito.log.Logger;
import no.g9.dataaccess.Session;
import no.g9.jgrape.DataServiceImpl;
import no.g9.jgrape.Manager;
import no.g9.jgrape.OsManager;
import no.g9.jgrape.SessionManager;
import no.g9.service.JGrapeParamWrapper;
import no.g9.service.JGrapeService;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.ClientContext;
import no.g9.support.FindData;
import no.g9.support.ObjectSelection;

public class JGrapeLocal
extends SessionManager
implements JGrapeService {
    private Logger logger = Logger.getLogger(JGrapeService.class);

    public JGrapeLocal() {
        this.logger.debug((Object)"Finished constructing JGrapeLocal.");
    }

    public Object find(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("FIND", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            result = manager.find(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations(result, ctx, session);
        return result;
    }

    public Object find(FindData findData, ClientContext ctx, String dbMapping) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("FIND", ctx, findData, dbMapping);
        this.logger.debug((Object)logObject);
        Object result = null;
        Session session = JGrapeLocal.getSession(ctx, dbMapping);
        try {
            DataServiceImpl dataService = new DataServiceImpl();
            result = dataService.find(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        return result;
    }

    public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("FINDALL", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        List<?> result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            result = manager.findAll(objectSelection, ctx, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResultAssociations(result, ctx, session);
        return result;
    }

    public List<?> findAll(FindData findData, ClientContext ctx, String dbMapping) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("FINDALL", ctx, findData, dbMapping);
        this.logger.debug((Object)logObject);
        List<?> result = null;
        Session session = JGrapeLocal.getSession(ctx, dbMapping);
        try {
            DataServiceImpl dataService = new DataServiceImpl();
            result = dataService.findAll(findData, session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        return result;
    }

    public Object save(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("SAVE", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.save(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object insert(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("INSERT", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.insert(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object update(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("UPDATE", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.update(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object delete(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("DELETE", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.delete(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object connect(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("CONNECT", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.connect(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object disconnect(ObjectSelection objectSelection, ClientContext ctx) {
        JGrapeParamWrapper logObject = new JGrapeParamWrapper("DISCONNECT", ctx, objectSelection);
        this.logger.debug((Object)logObject);
        Object result = null;
        Manager manager = OsManager.getManager(objectSelection);
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        try {
            session.beginTransaction();
            result = manager.disconnect(objectSelection, ctx, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                session.rollbackTransaction();
            }
            throw e;
        }
        finally {
            JGrapeLocal.getSessionFactory().closeSession(session);
        }
        manager.cleanupResult(result, ctx, session);
        return result;
    }

    public Object get(ObjectSelection objectSelection, ENavigation navigation, ClientContext ctx) {
        Object result = null;
        Session session = JGrapeLocal.getSession(objectSelection, ctx);
        JGrapeLocal.getSessionFactory().closeSession(session);
        return result;
    }
}

