/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import no.g9.dataaccess.HibernateSessionFactory;
import no.g9.dataaccess.Session;
import no.g9.dataaccess.SessionFactory;
import no.g9.exception.G9BaseException;
import no.g9.service.JGrapeParamWrapper;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;
import no.g9.support.Registry;

public abstract class SessionManager {
    private static final SessionFactory factory = HibernateSessionFactory.getSessionfactory();
    private static final String OS_MAPPING = ".osmapping";
    private static final String LOG_FILENAME = "JGrapeService.logfile";
    private static final String LOG_NUMFILES = "JGrapeService.numLogfiles";
    private static final String LOG_DATEFORMAT = "JGrapeService.logfileDateFormat";
    private static String logfileDateFormat = "yyyyMMdd_HHmm";
    public static final String LOG_CONTROL = "LogJGrapeService";
    private static ObjectOutputStream[] logStreams;
    private static String logFile;
    private static int numLogFiles;
    private static boolean logOn;

    public static SessionFactory getSessionFactory() {
        return factory;
    }

    public static Session getSession(ObjectSelection objectSelection, ClientContext ctx) {
        String dbContext = SessionManager.getDatabaseContextName(ctx, objectSelection.getApplicationName());
        String dbMapping = SessionManager.getDatabaseMappingName(objectSelection);
        return SessionManager.getSessionFactory().getSession(dbContext, dbMapping);
    }

    public static Session getSession(ClientContext ctx, String dbMapping) {
        String dbContext = SessionManager.getDatabaseContextName(ctx, null);
        return SessionManager.getSessionFactory().getSession(dbContext, dbMapping);
    }

    public static String getDatabaseContextName(ClientContext ctx, String appName) {
        String contextName = null;
        if (ctx != null) {
            contextName = ctx.getDatabaseContext();
        }
        if (contextName == null && appName != null) {
            Registry reg = Registry.getRegistry();
            String propName = "ServiceApplication." + appName + "." + "DefaultDatabaseContext";
            contextName = reg.getG9Property(propName);
        }
        return contextName;
    }

    public static String getDatabaseMappingName(ObjectSelection objectSelection) {
        String mappingName = null;
        String propFileName = objectSelection.getApplicationName() + OS_MAPPING;
        Registry reg = Registry.getRegistry();
        String propName = null;
        propName = objectSelection.getObjectSelectionName() + "." + objectSelection.getCurrentRootName();
        mappingName = reg.getApplicationProperty(propFileName, propName);
        if (mappingName == null && (mappingName = reg.getApplicationProperty(propFileName, propName = objectSelection.getObjectSelectionName())) == null) {
            propName = "ServiceApplication." + objectSelection.getApplicationName() + "." + "DefaultDatabaseMapping";
            mappingName = reg.getG9Property(propName);
        }
        return mappingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logParams(JGrapeParamWrapper logObject) {
        try {
            Class<SessionManager> clazz = SessionManager.class;
            synchronized (SessionManager.class) {
                if (logOn) {
                    int logfile = 0;
                    if (logObject.getCtx() != null && logObject.getCtx().getUserId() != null) {
                        logfile = logObject.getCtx().getUserId().hashCode() % logStreams.length;
                    }
                    logStreams[logfile].writeObject(logObject);
                    logStreams[logfile].reset();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new G9BaseException((Throwable)e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logControl(boolean on) {
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            if (on && !logOn) {
                SessionManager.openLog();
                logOn = true;
            } else if (logOn) {
                logOn = false;
                SessionManager.closeLog();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected boolean doLog() {
        return logOn;
    }

    private static void initLogSession() {
        logFile = Registry.getRegistry().getG9Property(LOG_FILENAME);
        numLogFiles = Integer.parseInt(Registry.getRegistry().getG9Property(LOG_NUMFILES));
        logfileDateFormat = Registry.getRegistry().getG9Property(LOG_DATEFORMAT);
        if (logFile != null && numLogFiles == 0) {
            numLogFiles = 1;
        }
    }

    private static void openLog() {
        try {
            SessionManager.initLogSession();
            String ts = "";
            if (SessionManager.getLogfileDateFormat().length() > 0) {
                SimpleDateFormat df = new SimpleDateFormat(SessionManager.getLogfileDateFormat());
                ts = "-" + df.format(Calendar.getInstance().getTime());
            }
            logStreams = new ObjectOutputStream[numLogFiles];
            for (int i = 1; i <= numLogFiles; ++i) {
                String fileName = logFile + ts + "." + i;
                FileOutputStream fos = new FileOutputStream(fileName);
                SessionManager.logStreams[i - 1] = new ObjectOutputStream(fos);
            }
        }
        catch (FileNotFoundException e) {
            throw new G9BaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new G9BaseException((Throwable)e);
        }
    }

    private static void closeLog() {
        try {
            for (int i = 1; i <= numLogFiles; ++i) {
                logStreams[i - 1].close();
            }
        }
        catch (IOException e) {
            throw new G9BaseException((Throwable)e);
        }
    }

    public static String getLogfileDateFormat() {
        return logfileDateFormat;
    }

    public static void setLogfileDateFormat(String logfileDateFormat) {
        SessionManager.logfileDateFormat = logfileDateFormat;
    }

    static {
        logFile = null;
        numLogFiles = 0;
        logOn = false;
    }
}

