/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.util.Properties;

/**
 * Interface used by the dataaccess usertypes which need a "split" model where
 * parts of the type is usable outside of Hibernate.
 */
public interface ParameterizedType {

    /**
     * Gets called to pass the configured type parameters to the implementation.
     * 
     * @param parameters (missing javadoc)
     */
    public void setParameterValues(Properties parameters);
}
