/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import no.g9.support.G9Enumerator;
import no.g9.support.ObjectFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class TextEnumeratorType
implements UserType,
ParameterizedType,
Serializable {
    private static final String NAME_METHOD = "name";
    private static final String GET_BY_NAME_METHOD = "getByName";
    private String defaultValue = null;
    private String enumClassName = null;
    private Class<?> enumClass;

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class<?> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object result = null;
        String tmpResult = rs.getString(names[0]);
        if (tmpResult != null) {
            result = this.getObjectValue(tmpResult);
        } else if (this.defaultValue != null) {
            result = this.getObjectValue(this.defaultValue);
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, this.getTextValue(value));
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (this.isJavaEnumClass()) {
            return value;
        }
        G9Enumerator result = null;
        if (value != null) {
            result = (G9Enumerator)ObjectFactory.newObject((String)this.enumClassName);
            result.setCurrentValue(((G9Enumerator)value).getCurrentValue());
        }
        return result;
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            if (parameters.get("class") != null) {
                this.enumClassName = (String)parameters.get("class");
                try {
                    this.enumClass = Class.forName(this.enumClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new HibernateException((Throwable)e);
                }
            }
            if (parameters.get("default") != null) {
                this.defaultValue = (String)parameters.get("default");
                if (this.defaultValue.equals("null")) {
                    this.defaultValue = null;
                }
            }
        }
    }

    private boolean isJavaEnumClass() {
        return this.enumClass.isEnum();
    }

    private Enum<?> getEnumObject(String textValue) {
        try {
            Method get = this.enumClass.getMethod(GET_BY_NAME_METHOD, String.class);
            return (Enum)get.invoke(null, textValue);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    private String getEnumValue(Object enumObject) {
        try {
            Method getValue = enumObject.getClass().getMethod(NAME_METHOD, null);
            return (String)getValue.invoke(enumObject, (Object[])null);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    private Object getObjectValue(String textValue) {
        G9Enumerator value = null;
        if (this.isJavaEnumClass()) {
            value = this.getEnumObject(textValue);
        } else {
            G9Enumerator geVal = (G9Enumerator)ObjectFactory.newObject((String)this.enumClassName);
            geVal.assignFromName(textValue);
            value = geVal;
        }
        return value;
    }

    private String getTextValue(Object objectValue) {
        String value = this.isJavaEnumClass() ? this.getEnumValue(objectValue) : ((G9Enumerator)objectValue).currentAsName();
        return value;
    }
}

