/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess;

import java.util.LinkedList;
import java.util.List;

import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;

/**
 * This class holds a list of Hibernate resource files. Files may be added
 * one by one, or a new list of files may be set.
 *
 * The list of resource files can be added to a Hibernate configuration.
 */
public class HibernateResources {

    private List<String> resourceFiles = new LinkedList<String>();

    /**
     * @return the resource file list
     */
    public List<String> getResourceFiles() {
        return resourceFiles;
    }

    /**
     * Set the resource file list.
     *
     * @param resourceFiles the new resource file list
     */
    public void setResourceFiles(List<String> resourceFiles) {
        this.resourceFiles = resourceFiles;
    }

    /**
     * Add the given resource file to the list of resource files.
     *
     * @param file the resource file to add
     */
    public void addResourceFile(String file) {
        resourceFiles.add(file);
    }

    /**
     * Add the set of resource files to the given Hibernate configuration.
     *
     * @param configuration add the resource files to this configuration
     */
    public void addResourcesToConfiguration(Configuration configuration) {
        if (configuration != null) {
            for (String file : resourceFiles) {
                try {
                    configuration.addResource(file);
                } catch (MappingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

}
