/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import no.g9.dataaccess.usertype.ParameterizedType;

/**
 * (missing javadoc)
 */
public class IntDate implements ParameterizedType, Serializable {

    private String dateFormat = "yyyyMMdd";

    private Date defaultValue = null;

    private SimpleDateFormat dateFormatter = null;

    /**
     * @param parameters (missing javadoc)
     */
    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            if (parameters.get("default") != null) {
                String defaultVal = (String) parameters.get("default");
                if (!defaultVal.equals("null")) {
                    this.defaultValue = fromInt(Integer.parseInt(defaultVal));
                }
            }
            if (parameters.get("format") != null) {
                this.dateFormat = (String) parameters.get("format");
            }
        }
        dateFormatter = new SimpleDateFormat(this.dateFormat);
    }

    /**
     * Conversion from int to Date
     *
     * @param value (missing javadoc)
     * @return (missing javadoc)
     */
    public synchronized Date fromInt(int value) {
        Date result = null;
        if (value != 0) {
            try {
                result = dateFormatter.parse(Integer.toString(value));
            } catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
        return result;
    }

    /**
     * Conversion from Date to int
     *
     * @param value (missing javadoc)
     * @return (missing javadoc)
     */
    public synchronized Integer fromDate(Date value) {
        if (value != null) {
            return new Integer(dateFormatter.format(value));
        }
        return null;
    }

    /**
     * @return (missing javadoc)
     */
    public String getDateFormat() {
        return dateFormat;
    }

    /**
     * @param dateFormat the dateFormat to set
     */
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    /**
     * @return (missing javadoc)
     */
    public SimpleDateFormat getDateFormatter() {
        return dateFormatter;
    }

    /**
     * @param dateFormatter the dateFormatter to set
     */
    public void setDateFormatter(SimpleDateFormat dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    /**
     * @return the defaultValue
     */
    public Date getDefaultValue() {
        return (defaultValue != null) ? new Date(defaultValue.getTime()) : null;
    }

    /**
     * @param defaultValue the defaultValue to set
     */
    public void setDefaultValue(Date defaultValue) {
        if (defaultValue != null) { 
            this.defaultValue= new Date(defaultValue.getTime());
        } else {
            this.defaultValue= null;
        }
    }

}
