/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.util.Properties;

import no.g9.dataaccess.usertype.ParameterizedType;

/**
 * Based on org.hibernate.test.typeparameters.DefaultValueIntegerType
 */
public class TextBoolean implements ParameterizedType, Serializable {

    private Boolean defaultValue = null;

    private String falseSaveValue = "N";

    private String trueSaveValue = "J";

    private String[] trueValues;

    /**
     * @param parameters (missing javadoc)
     */
    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String paramValue = (String) parameters.get("default");
            if (paramValue != null) {
                if (!paramValue.equals("null")) {
                    this.defaultValue = new Boolean(paramValue);
                }
            }
            paramValue = (String) parameters.get("falseSaveValue");
            if (paramValue != null) {
                this.falseSaveValue = paramValue;
            }
            paramValue = (String) parameters.get("trueSaveValue");
            if (paramValue != null) {
                this.trueSaveValue = paramValue;
            }
            paramValue = (String) parameters.get("trueValues");
            if (paramValue != null) {
                this.trueValues = paramValue.split(",");
                for (int i = 0; i < trueValues.length; ++i) {
                    trueValues[i] = trueValues[i].trim();
                }
            }
        }
    }

    /**
     * Convert from String to Boolean
     * 
     * @param value (missing javadoc)
     * @return (missing javadoc)
     */
    public Boolean fromText(String value) {
        Boolean result = defaultValue;
        if (value != null) {
            result = Boolean.FALSE;
            for (int i = 0; i < trueValues.length; ++i) {
                if (trueValues[i].equalsIgnoreCase(value.trim())) {
                    result = Boolean.TRUE;
                }
            }
        }
        return result;
    }

    /**
     * Convert from Boolean to String
     * 
     * @param value (missing javadoc)
     * @return (missing javadoc)
     */
    public String fromBoolean(Boolean value) {
        if (value != null) {
            if (value.booleanValue()) {
                return trueSaveValue;
            }
            return falseSaveValue;
        }
        return null;
    }

    /**
     * @return the defaultValue
     */
    public Boolean getDefaultValue() {
        return defaultValue;
    }

    /**
     * @param defaultValue the defaultValue to set
     */
    public void setDefaultValue(Boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * @return the falseSaveValue
     */
    public String getFalseSaveValue() {
        return falseSaveValue;
    }

    /**
     * @param falseSaveValue the falseSaveValue to set
     */
    public void setFalseSaveValue(String falseSaveValue) {
        this.falseSaveValue = falseSaveValue;
    }

    /**
     * @return the trueSaveValue
     */
    public String getTrueSaveValue() {
        return trueSaveValue;
    }

    /**
     * @param trueSaveValue the trueSaveValue to set
     */
    public void setTrueSaveValue(String trueSaveValue) {
        this.trueSaveValue = trueSaveValue;
    }

    /**
     * @return the trueValues
     */
    public String[] getTrueValues() {
        return trueValues.clone();
    }

    /**
     * @param trueValues the trueValues to set
     */
    public void setTrueValues(String[] trueValues) {
        this.trueValues = trueValues.clone();
    }
}
