/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.trigger;

import no.g9.dataaccess.Session;
import no.g9.support.ClientContext;

/**
 * JGrapeTrigger is a trigger for generated JGrape Service Managers.  
 * 
 * @param <T> The domain type supported by this trigger.
 */
public interface JGrapeTrigger<T> {

    /**
     * Enumerates the possible trigger types.
     */
    enum TriggerType {
        /** Delete trigger, used on action <em>delete</em>. */
        DELETE,

        /** Insert trigger, used on action <em>insert</em>. */
        INSERT,
        
        /** Update trigger, used on action <em>update</em>. */
        UPDATE,
        
        
        /** Save trigger, used on action <em>save</em>. */
        SAVE,
        
        /**
         * All trigger, used on actions <em>insert, update, delete</em> and
         * <em>save</em> .
         */
        ALL;
        
    }
   
    /**
     * The trigger that is invoked by JGrape Service Managers. 
     * 
     * @param domainObject the actual instance
     * @param type the type of trigger
     * @param isTargetNode <code>true</code> if the current object's role is the
     *            target node in the object selection.
     * @param ctx the client context
     * @param session the current session
     */
    void trigger(T domainObject, TriggerType type, boolean isTargetNode,
        ClientContext ctx, Session session);

    /**
     * Get the trigger type of this trigger.
     * 
     * @return this trigger's TriggerType
     */
    TriggerType getTriggerType();
}
