/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.trigger;

import java.util.List;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;

/**
 * Provides triggers for the domain classes.
 */
@BeanID("triggerProvider")
@G9PropertyName("TriggerProvider")
public interface TriggerProvider {

    /**
     * Provides a list of triggers for the specified domain class and trigger
     * type. The list includes triggers specified for all super classes and
     * interfaces. The sequence of triggers are the following:
     * <ol>
     * <li>Triggers defined on superclass, Interface triggers before class
     * triggers (recursively from Object.class and down to specified domain
     * class)
     * <li>Local interface triggers (super interface before sub-interface)
     * <li>Triggers defined on specified domain class.
     * </ol>
     * <p>
     * Consider the following class hierarchy: 
     * 
     * <code>
     * Interface IA
     * Interface IB extends IA
     * Interface IBB
     * class A implements IA
     * class B implements IB, IBB
     * </code> 
     * 
     * And for each class and interface, one or more registered
     * triggers. The derived trigger list for class B is then:
     * <ol>
     * <li>triggers for IA
     * <li>triggers for A
     * <li>triggers for IB
     * <li>triggers for IBB
     * <li>triggers for B
     * </ol>
     * 
     * @param domainClass the domain class.
     * @param type the trigger type.
     * @return the list of triggers for the specified class, including super
     *         class triggers and interface triggers.
     */
    List<JGrapeTrigger<?>> getTrigger(Class<?> domainClass,
        JGrapeTrigger.TriggerType type);
}
