/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.tx;

import no.g9.support.ClientContext;

/**
 * Defines the transaction service interface.
 */
public interface TxService {

    /**
     * Run a command within a separate transaction.
     * 
     * @param clientContext Current database context
     * @param databaseMappingName Current database mapping name
     * @param command The code to execute within its own transaction
     * @return TxCommand The (reserialized) object that was passed in
     */
    TxCommand executeCommand(ClientContext clientContext,
                             String databaseMappingName,
                             TxCommand command);

}
