/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.tx;

import no.g9.exception.G9BaseException;
import no.g9.message.CRuntimeMsg;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.service.G9Spring;
import no.g9.support.ClientContext;

/**
 *
 */
public class TxSpring extends G9Spring implements TxService {

    private TxService txService;

    /**
     * Create the Spring connection.
     */
    public TxSpring() {
        super();
        txService = (TxService) getApplicationContext().getBean("txService");
    }

    /** {@inheritDoc } */
    @Override
    public TxCommand executeCommand(final ClientContext clientContext,
                                    final String databaseMappingName,
                                    final TxCommand command) {
        TxCommand returnedCommand = null;
        try {
            returnedCommand = txService.executeCommand(clientContext, databaseMappingName, command);
        }
        catch (RuntimeException exception) {
            wrapException(exception);
        }
        return returnedCommand;
    }

    
    
    /**
     * Wrap any "unknown" exceptions in a G9BaseException.
     * 
     * @param exception the exception to wrap.
     * @throws G9BaseException the wrapped exception.
     */
    private void wrapException(RuntimeException exception)
            throws G9BaseException {

        if (exception instanceof G9BaseException) {
            throw exception;
        }

        Throwable cause = exception.getCause();
        if (cause == null) {
            createG9Exception(exception);
        }
        if (cause instanceof G9BaseException) {
            throw (G9BaseException) cause;
        }
        createG9Exception(cause);
    }

    private void createG9Exception(Throwable cause)
            throws G9BaseException {
        Message m= MessageSystem.getMessageFactory().getMessage(CRuntimeMsg.UNHANDLED_EXCEPTION, cause.getMessage());
        throw new G9BaseException(cause, m);
    }

}
