/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess;

import java.io.Serializable;
import no.g9.dataaccess.AbstractHibernateSession;
import no.g9.exception.G9DataAccessException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.FindData;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class HibernateStatelessSession
extends AbstractHibernateSession {
    protected StatelessSession session;

    public HibernateStatelessSession(StatelessSession session) {
        this.session = session;
    }

    public StatelessSession getSession() {
        return this.session;
    }

    @Override
    public boolean hasLockFlag(Class<?> domainClass) {
        Object[] args = new Object[]{"hasLockFlag() not supported for stateless sessions"};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9DataAccessException(msg);
    }

    @Override
    protected Object simpleGetImpl(FindData findData) {
        return this.session.get(findData.getDomainClass(), findData.getKey());
    }

    @Override
    protected Criteria createCriteriaImpl(FindData findData) {
        return this.session.createCriteria(findData.getDomainClass());
    }

    @Override
    protected Serializable insertImpl(Object object) {
        return this.session.insert(object);
    }

    @Override
    protected void updateImpl(Object object) {
        this.session.update(object);
    }

    @Override
    protected Object mergeImpl(Object object) {
        Object[] args = new Object[]{"merge() not supported for stateless sessions"};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9DataAccessException(msg);
    }

    @Override
    protected void deleteImpl(Object object) {
        this.session.delete(object);
    }

    @Override
    protected void refreshImpl(Object object) {
        this.session.refresh(object);
    }

    @Override
    protected void closeImpl() {
        this.session.close();
    }

    @Override
    protected void flushImpl() {
        Object[] args = new Object[]{"flush() not supported for stateless sessions"};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9DataAccessException(msg);
    }

    @Override
    protected Transaction beginTransactionImpl() {
        return this.session.beginTransaction();
    }

    @Override
    protected boolean hasActiveTransactionImpl() {
        return this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE;
    }

    @Override
    protected Query buildQueryImpl(String queryString) {
        return this.session.createQuery(queryString);
    }

    @Override
    public void initialize(Object object) throws G9DataAccessException {
        Object[] args = new Object[]{"initialize() not supported for stateless sessions"};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9DataAccessException(msg);
    }
}

