/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import no.g9.support.Numeric;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class BcdType
implements UserType,
ParameterizedType,
Serializable {
    public static final BigDecimal BIG_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final BigDecimal BIG_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private Object defaultValue = null;
    private int scale = 0;
    private boolean isG9Numeric = false;

    public int[] sqlTypes() {
        return new int[]{2};
    }

    public Class returnedClass() {
        return this.isG9Numeric ? Numeric.class : BigDecimal.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        BigDecimal result = rs.getBigDecimal(names[0]);
        return result == null ? this.defaultValue : (this.isG9Numeric ? this.fromBase(result) : result);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 2);
        } else {
            BigDecimal big = null;
            if (this.isG9Numeric) {
                Numeric numericValue = (Numeric)value;
                big = this.fromJava(numericValue);
            } else {
                big = (BigDecimal)value;
            }
            if (this.scale == 0 && big.compareTo(BIG_MAX_LONG) <= 0 && big.compareTo(BIG_MIN_LONG) >= 0) {
                st.setLong(index, big.longValue());
            } else {
                st.setBigDecimal(index, big);
            }
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (this.isG9Numeric) {
            return ((Numeric)value).clone();
        }
        BigDecimal big = (BigDecimal)value;
        return new BigDecimal(big.unscaledValue(), big.scale());
    }

    public boolean isMutable() {
        return true;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String defaultVal;
            if (parameters.get("scale") != null) {
                this.scale = Integer.parseInt((String)parameters.get("scale"));
            }
            if (parameters.get("g9numeric") != null) {
                this.isG9Numeric = Boolean.parseBoolean((String)parameters.get("g9numeric"));
            }
            if (parameters.get("default") != null && !(defaultVal = (String)parameters.get("default")).equals("null")) {
                this.defaultValue = this.isG9Numeric ? new Numeric(defaultVal, this.scale) : new BigDecimal(defaultVal).setScale(this.scale, 4);
            }
        }
    }

    private Numeric fromBase(BigDecimal value) {
        if (value != null) {
            return new Numeric(value, this.scale);
        }
        return null;
    }

    private BigDecimal fromJava(Numeric value) {
        if (value != null) {
            return value.getValue();
        }
        return null;
    }
}

