/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import no.g9.support.G9Enumerator;
import no.g9.support.ObjectFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EnumeratorType
implements UserType,
ParameterizedType,
Serializable {
    private static final String GET_VALUE_METHOD = "getValue";
    private static final String GET_METHOD = "get";
    private String defaultValue = null;
    private String enumClassName = null;
    private Class<?> enumClass;

    public int[] sqlTypes() {
        return new int[]{4};
    }

    public Class<?> returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object result = null;
        Number tmpResult = (Number)rs.getObject(names[0]);
        if (tmpResult != null) {
            result = this.getObjectValue(tmpResult.intValue());
        } else if (this.defaultValue != null) {
            result = this.getObjectValue(Integer.parseInt(this.defaultValue));
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 4);
        } else {
            st.setInt(index, this.getIntValue(value));
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (this.isJavaEnumClass()) {
            return value;
        }
        G9Enumerator result = null;
        if (value != null) {
            result = (G9Enumerator)ObjectFactory.newObject((String)this.enumClassName);
            result.setCurrentValue(((G9Enumerator)value).getCurrentValue());
        }
        return result;
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            if (parameters.get("class") != null) {
                this.enumClassName = (String)parameters.get("class");
                try {
                    this.enumClass = Class.forName(this.enumClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new HibernateException((Throwable)e);
                }
            }
            if (parameters.get("default") != null) {
                this.defaultValue = (String)parameters.get("default");
                if (this.defaultValue.equals("null")) {
                    this.defaultValue = null;
                }
            }
        }
    }

    private boolean isJavaEnumClass() {
        return this.enumClass.isEnum();
    }

    private Enum<?> getEnumObject(int intValue) {
        try {
            Method get = this.enumClass.getMethod(GET_METHOD, Integer.TYPE);
            return (Enum)get.invoke(null, intValue);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    private Integer getEnumValue(Object enumObject) {
        try {
            Method getValue = enumObject.getClass().getMethod(GET_VALUE_METHOD, null);
            return (Integer)getValue.invoke(enumObject, (Object[])null);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    private Object getObjectValue(int intValue) {
        G9Enumerator value = null;
        if (this.isJavaEnumClass()) {
            value = this.getEnumObject(intValue);
        } else {
            G9Enumerator geVal = (G9Enumerator)ObjectFactory.newObject((String)this.enumClassName);
            geVal.setCurrentValue(intValue);
            value = geVal;
        }
        return value;
    }

    private int getIntValue(Object objectValue) {
        int value = this.isJavaEnumClass() ? this.getEnumValue(objectValue).intValue() : ((G9Enumerator)objectValue).getCurrentValue();
        return value;
    }
}

