/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import no.g9.dataaccess.usertype.ParameterizedType;

public class IntLocalDate
implements ParameterizedType,
Serializable {
    private String dateFormat = "yyyyMMdd";
    private LocalDate defaultValue = null;

    @Override
    public synchronized void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String defaultVal;
            if (parameters.get("default") != null && !(defaultVal = (String)parameters.get("default")).equals("null")) {
                this.defaultValue = this.fromInt(Integer.parseInt(defaultVal));
            }
            if (parameters.get("format") != null) {
                this.dateFormat = (String)parameters.get("format");
            }
        }
    }

    public synchronized LocalDate fromInt(int value) {
        LocalDate result = null;
        if (value != 0) {
            try {
                result = LocalDate.parse(Integer.toString(value), DateTimeFormatter.ofPattern(this.dateFormat));
            }
            catch (DateTimeParseException pe) {
                throw new RuntimeException(pe);
            }
        }
        return result;
    }

    public synchronized Integer fromLocalDate(LocalDate value) {
        if (value != null) {
            return new Integer(value.format(DateTimeFormatter.ofPattern(this.dateFormat)));
        }
        return null;
    }

    public LocalDate getDefaultValue() {
        return this.defaultValue != null ? LocalDate.from(this.defaultValue) : null;
    }
}

