/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.EnhancedUserType;

public class PersistentLocalTime
implements EnhancedUserType,
Serializable {
    private static final int[] SQL_TYPES = new int[]{93};
    private static final int A_YEAR = 2000;
    private static final int A_MONTH = 1;
    private static final int A_DAY = 1;

    public int[] sqlTypes() {
        return (int[])SQL_TYPES.clone();
    }

    public Class<LocalTime> returnedClass() {
        return LocalTime.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        LocalTime dtx = (LocalTime)x;
        LocalTime dty = (LocalTime)y;
        return dtx.equals(dty);
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, strings[0], session);
    }

    private Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor session) throws SQLException {
        Object time = StandardBasicTypes.TIME.nullSafeGet(resultSet, string, session);
        if (time == null) {
            return null;
        }
        Date t = (Date)time;
        Instant instant = Instant.ofEpochMilli(t.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            StandardBasicTypes.TIME.nullSafeSet(preparedStatement, null, index, session);
        } else {
            LocalTime lt = (LocalTime)value;
            Instant instant = lt.atDate(LocalDate.of(2000, 1, 1)).atZone(ZoneId.systemDefault()).toInstant();
            Date time = new Date(instant.toEpochMilli());
            StandardBasicTypes.TIME.nullSafeSet(preparedStatement, (Object)time, index, session);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object value) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public String objectToSQLString(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toXMLString(Object object) {
        return object.toString();
    }

    public Object fromXMLString(String string) {
        return LocalTime.parse(string);
    }
}

