/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.tx;

import no.g9.exception.G9BaseException;
import no.g9.jgrape.tx.TxCommand;
import no.g9.jgrape.tx.TxService;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.service.G9Spring;
import no.g9.support.ClientContext;

public class TxSpring
extends G9Spring
implements TxService {
    private TxService txService = (TxService)TxSpring.getApplicationContext().getBean("txService");

    @Override
    public TxCommand executeCommand(ClientContext clientContext, String databaseMappingName, TxCommand command) {
        TxCommand returnedCommand = null;
        try {
            returnedCommand = this.txService.executeCommand(clientContext, databaseMappingName, command);
        }
        catch (RuntimeException exception) {
            this.wrapException(exception);
        }
        return returnedCommand;
    }

    private void wrapException(RuntimeException exception) throws G9BaseException {
        if (exception instanceof G9BaseException) {
            throw exception;
        }
        Throwable cause = exception.getCause();
        if (cause == null) {
            this.createG9Exception(exception);
        }
        if (cause instanceof G9BaseException) {
            throw (G9BaseException)cause;
        }
        this.createG9Exception(cause);
    }

    private void createG9Exception(Throwable cause) throws G9BaseException {
        Message m = MessageSystem.getMessageFactory().getMessage("-1000", new Object[]{cause.getMessage()});
        throw new G9BaseException(cause, m);
    }
}

