/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess;

/**
 * The session factory is used for creating a new <code>Session</code>
 * instance, and to close a session.
 *
 */
public interface SessionFactory {

    /**
     * Get a session instance.<br>
     * The session is shared within the thread.
     *
     * @param contextName the database context.
     * @param mappingName the database mapping.
     * @return (missing javadoc)
     */
    public Session getSession(final String contextName, final String mappingName);

    /**
     * Get a stateless session instance.<br>
     * The session is not shared within the thread.
     *
     * @param contextName the database context.
     * @param mappingName the database mapping.
     * @return (missing javadoc)
     */
    public Session getStatelessSession(final String contextName, final String mappingName);

    /**
     * Get a copy of the given session.<br>
     * The session is not shared within the thread. Transactions will be
     * isolated from the original session, unless transactions are managed by a
     * container.
     *
     * @param session the session to clone.
     * @return (missing javadoc)
     */
    public Session cloneSession(final Session session);

    /**
     * Close the given session.
     *
     * @param session (missing javadoc)
     */
    public void closeSession(final Session session);

}
