/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/**
 * Based on org.hibernate.test.typeparameters.DefaultValueIntegerType
 */
public class BooleanType implements UserType, ParameterizedType, Serializable {

    private Boolean defaultValue = null;

    /**
     * @return (missing javadoc)
     */
    @Override
    public int[] sqlTypes() {
        return new int[] { Types.TINYINT };
    }

    /**
     * @return (missing javadoc)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public Class returnedClass() {
        return Boolean.class;
    }

    /**
     * @param x (missing javadoc)
     * @param y (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y)
            return true;
        if (x == null || y == null)
            return false;
        return x.equals(y);
    }

    /**
     * @param rs (missing javadoc)
     * @param names (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     * @throws java.sql.SQLException (missing javadoc)
     */
    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner)
            throws HibernateException, SQLException {
        boolean result = rs.getBoolean(names[0]);
        return rs.wasNull() ? defaultValue : new Boolean(result);
    }

    /**
     * @param st (missing javadoc)
     * @param value (missing javadoc)
     * @param index (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     * @throws java.sql.SQLException (missing javadoc)
     */
    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session)
            throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, Types.TINYINT);
        } else {
            st.setBoolean(index, ((Boolean) value).booleanValue());
        }
    }

    /**
     * @param value (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object deepCopy(Object value) throws HibernateException {
        if (value != null) {
            return new Boolean(((Boolean) value).booleanValue());
        }
        return null;
    }

    /**
     * @return (missing javadoc)
     */
    @Override
    public boolean isMutable() {
        return false;
    }

    /**
     * @param x (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    /**
     * @param cached (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object assemble(Serializable cached, Object owner)
            throws HibernateException {
        return cached;
    }

    /**
     * @param value (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable) value;
    }

    /**
     * @param original (missing javadoc)
     * @param target (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object replace(Object original, Object target, Object owner)
            throws HibernateException {
        return original;
    }

    /**
     * @param parameters (missing javadoc)
     */
    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            if (parameters.get("default") != null) {
                String defaultVal = (String) parameters.get("default");
                if (!defaultVal.equals("null")) {
                    this.defaultValue = Boolean.valueOf(defaultVal);
                }
            }
        }
    }

}
