/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.joda.time.DateMidnight;

/**
 * Persist {@link org.joda.time.DateMidnight} via hibernate.
 *
 * Based on org.joda.time.contrib.hibernate.PersistentDateTime by Mario Ivankovits (mario@ops.co.at)
 */
@SuppressWarnings({ "deprecation", "javadoc" })
public class PersistentDateMidnight implements EnhancedUserType, Serializable {

    private static final int[] SQL_TYPES = new int[] { Types.TIMESTAMP, };

    @Override
    public int[] sqlTypes() {
        return SQL_TYPES.clone();
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Class returnedClass() {
        return DateMidnight.class;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        DateMidnight dtx = (DateMidnight) x;
        DateMidnight dty = (DateMidnight) y;

        return dtx.equals(dty);
    }

    @Override
    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object object) throws HibernateException, SQLException {
        Date date = rs.getDate(names[0]);
        if (date == null) {
            return null;
        }
		DateMidnight dateMidnight = new DateMidnight(date);
        return dateMidnight;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, Types.TIMESTAMP);
        } else {
            Timestamp tstamp = new Timestamp(((DateMidnight) value).getMillis());
            st.setTimestamp(index, tstamp);
        }
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable) value;
    }

    @Override
    public Object assemble(Serializable cached, Object value) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public String objectToSQLString(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toXMLString(Object object) {
        return object.toString();
    }

    @Override
    public Object fromXMLString(String string) {
        return new DateMidnight(string);
    }

}
