/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/**
 * Based on org.hibernate.test.typeparameters.DefaultValueIntegerType
 */
@SuppressWarnings("rawtypes")
public class TextBooleanType extends TextBoolean implements UserType,
        ParameterizedType {

    /**
     * @return (missing javadoc)
     */
    @Override
    public int[] sqlTypes() {
        return new int[] { Types.VARCHAR };
    }

    /**
     * @return (missing javadoc)
     */
    @Override
    public Class returnedClass() {
        return Boolean.class;
    }

    /**
     * @param x (missing javadoc)
     * @param y (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y)
            return true;
        if (x == null || y == null)
            return false;
        return x.equals(y);
    }

    /**
     * @param rs (missing javadoc)
     * @param names (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     * @throws java.sql.SQLException (missing javadoc)
     */
    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner)
            throws HibernateException, SQLException {
        return fromText(rs.getString(names[0]));
    }

    /**
     * @param st (missing javadoc)
     * @param value (missing javadoc)
     * @param index (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     * @throws java.sql.SQLException (missing javadoc)
     */
    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session)
            throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, Types.VARCHAR);
        } else {
            st.setString(index, fromBoolean((Boolean) value));
        }
    }

    /**
     * @param value (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    /**
     * @return (missing javadoc)
     */
    @Override
    public boolean isMutable() {
        return false;
    }

    /**
     * @param x (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    /**
     * @param cached (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object assemble(Serializable cached, Object owner)
            throws HibernateException {
        return cached;
    }

    /**
     * @param value (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable) value;
    }

    /**
     * @param original (missing javadoc)
     * @param target (missing javadoc)
     * @param owner (missing javadoc)
     * @return (missing javadoc)
     * @throws org.hibernate.HibernateException (missing javadoc)
     */
    @Override
    public Object replace(Object original, Object target, Object owner)
            throws HibernateException {
        return original;
    }

}
