/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape;

import java.io.Serializable;
import no.g9.dataaccess.Session;
import java.util.List;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.FindData;

/**
 * The data service interface
 */
public interface DataService {

    /**
     * Finds an object based on the primary key given in the input object.
     *
     * @param clazz (missing javadoc)
     * @param key (missing javadoc)
     * @param findData (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public Object find(Class<?> clazz, Object key, FindData findData, Session session);

    /**
     * Finds an object based on a candidate key. The parameter keyAttributeNames
     * determines which object attributes to use to find the complete object.
     *
     * @param clazz (missing javadoc)
     * @param key (missing javadoc)
     * @param keyAttributeNames (missing javadoc)
     * @param findData (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public Object find(Class<?> clazz, Object key, List<String> keyAttributeNames,
            FindData findData, Session session);

    /**
     * Finds an object or a projection based on the given FindData.
     *
     * @param findData (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public Object find(FindData findData, Session session);

    /**
     * return purposes and if a maxSize parameter should be given as input or
     * set in the configuration.
     *
     * @param clazz (missing javadoc)
     * @param example (missing javadoc)
     * @param findData (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public List<?> findAll(Class<?> clazz, Object example, FindData findData, Session session);

    /**
     * Finds objects or projections based on the given FindData.
     *
     * @param findData (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public List<?> findAll(FindData findData, Session session);

    /**
     * Insert the given object in the database.
     *
     * @param object (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public Serializable insert(Object object, Session session);

    /**
     * Update a database instance from the given object.
     *
     * @param object (missing javadoc)
     * @param session (missing javadoc)
     */
    public void update(Object object, Session session);

    /**
     * Copy the state of the detached instance to a persistent instance with the
     * same identifier. The persistent instance will be loaded if necessary.
     *
     * @param object the detached instance
     * @param session (missing javadoc)
     * @return the persistent instance
     */
    public Object merge(Object object, Session session);

    /**
     * Delete the given object.
     *
     * @param object (missing javadoc)
     * @param session (missing javadoc)
     */
    public void delete(Object object, Session session);

    /**
     * @param object (missing javadoc)
     * @param keyAttributes (missing javadoc)
     * @param session (missing javadoc)
     */
    public void delete(Object object, List<String> keyAttributes, Session session);

    /**
     * @param currentObject (missing javadoc)
     * @param navigation (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
    public Object get(Object currentObject, ENavigation navigation, Session session);

    /**
     * Runs Hibernate.initialize(). The Session parameter will give the
     * operation the ability to attach objects in the current session.
     *
     * @param object (missing javadoc)
     * @param session (missing javadoc)
     */
    public void findAssociated(Object object, Session session);

}
