/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape;

import no.g9.support.ObjectSelection;
import no.g9.support.ClientContext;
import no.g9.dataaccess.Session;
import no.g9.service.enumerator.ENavigation;
import java.util.List;

/**
 * Interface for the jgrape service manager
 */
public interface Manager {
   
   /**
    * Find a single object.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object find(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Find multiple objects.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Save an object. A save is either an update or an insert.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object save(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Insert a new object.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object insert(ObjectSelection objectSelection, ClientContext ctx, Session session);

    /**
     * Update an existing object.
     * 
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @param session (missing javadoc)
     * @return (missing javadoc)
     */
   public Object update(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Delete an existing object.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object delete(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Connect an object to it's parent.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object connect(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * Disconnect an object from it's parent.
    * 
    * @param objectSelection (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object disconnect(ObjectSelection objectSelection, ClientContext ctx, Session session);
   
   /**
    * @param objectSelection (missing javadoc)
    * @param navigation (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    * @return (missing javadoc)
    */
   public Object get(ObjectSelection objectSelection, ENavigation navigation, ClientContext ctx, Session session);

   /**
    * Postprocess the result after transaction is ended
    * 
    * @param rootResult (missing javadoc)
    *
    * This method is replaced with
    * cleanupResult(Object rootResult, ClientContext ctx)
    * It is included in the interface for compatibility reasons
    */
   @Deprecated
   public void cleanupResult(Object rootResult);

   /**
    * Postprocess the result after transaction is ended
    * 
    * @param rootResult (missing javadoc)
    * @param ctx (missing javadoc)
    */
   @Deprecated
   public void cleanupResult(Object rootResult, ClientContext ctx);

   /**
    * Postprocess the result after transaction is ended
    * 
    * @param rootResult (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    */
   public void cleanupResult(Object rootResult, ClientContext ctx, Session session);

   /**
    * Postprocess the result after find actions
    * 
    * @param rootResult (missing javadoc)
    * @param ctx (missing javadoc)
    * @param session (missing javadoc)
    */
   public void cleanupResultAssociations(Object rootResult, ClientContext ctx, Session session);
}
