/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.trigger;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Required;

/**
 * The default trigger registry implementation.
 */
public class MappedTriggerRegistry implements TriggerRegistry {

    private Map<Class<?>, List<JGrapeTrigger<?>>> triggerMap;

    @Override
    public List<JGrapeTrigger<?>> getRegistredTriggers(Class<?> clazz) {
        return triggerMap.get(clazz);
    }

    /**
     * Set the trigger map. The triggerMap maps <code>java.lang.Class</code> to
     * a <code>java.util.List of JGrapeTriggers</code> to be used for that
     * class.
     * 
     * @param triggerMap the map from <code>java.lang.Class</code> to a list of
     *            <code>JGrapeTriggers</code>.
     * @throws IllegalArgumentException if the specified trigger map is
     *             <code>null</code>.
     */
    @Required
    public void setTriggerMap(Map<Class<?>, List<JGrapeTrigger<?>>> triggerMap) {
        if (triggerMap == null) {
            throw new IllegalArgumentException("Trigger map cannot be null!");
        }
        this.triggerMap = triggerMap;
    }

    @Override
    public String toString() {
        return "MappedTriggerRegistry [triggerMap=" + triggerMap + "]";
    }

}
