/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.trigger;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * Manages the trigger registries. All trigger registries are auto-wired by
 * Spring.
 */
public class RegistryManager {

    /** The list of trigger registries */
    @Autowired
    private List<TriggerRegistry> triggerRegistries;

    /**
     * Iterates all trigger registries and collects the list of triggers for the
     * specified class.
     * 
     * @param clazz the class to get triggers for.
     * @return a (possibly empty but not <code>null</code>) list of triggers registered for the specified
     *         class.
     */
    public final List<JGrapeTrigger<?>> getTriggerList(Class<?> clazz) {
        List<JGrapeTrigger<?>> triggerList = new ArrayList<JGrapeTrigger<?>>();

        if (triggerRegistries != null) {
            for (TriggerRegistry registry : triggerRegistries) {
                List<JGrapeTrigger<?>> registredTriggers = registry
                    .getRegistredTriggers(clazz);
                if (registredTriggers != null) {
                    triggerList.addAll(registredTriggers);
                }
            }
        }

        return triggerList;
    }

}