/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import no.esito.log.Logger;
import no.g9.dataaccess.AbstractHibernateSession;
import no.g9.dataaccess.HibernateProperties;
import no.g9.dataaccess.HibernateResources;
import no.g9.dataaccess.HibernateSession;
import no.g9.dataaccess.HibernateStatelessSession;
import no.g9.dataaccess.Session;
import no.g9.dataaccess.SessionFactory;
import no.g9.exception.G9DataAccessException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.service.G9Spring;
import no.g9.support.Registry;
import no.g9.support.RegistrySet;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class HibernateSessionFactory
implements SessionFactory {
    private static SessionFactory sessionFactory;
    private static String databaseServerSuffix;
    private static String databasePropertiesSuffix;
    private static String databaseConfigurationSuffix;
    private static String beanPrefix;
    private static String beanDefaultPart;
    private static final String hibernatePropertiesFile = "hibernate.properties";
    private static final String DEFAULT_CONTEXT = "*";
    private final Map<String, org.hibernate.SessionFactory> sessionFactories = new HashMap<String, org.hibernate.SessionFactory>();
    private final Map<String, ThreadLocal<Object>> sessionHolders = new HashMap<String, ThreadLocal<Object>>();
    private Logger logger = Logger.getLogger(HibernateSessionFactory.class);

    private HibernateSessionFactory() {
    }

    @Override
    public synchronized Session getSession(String contextName, String mappingName) throws G9DataAccessException {
        ThreadLocal<Object> sessionHolder = this.getSessionHolder(contextName, mappingName);
        Session s = (Session)sessionHolder.get();
        if (s == null) {
            s = this.openSession(this.getSessionFactory(contextName, mappingName), false);
            sessionHolder.set(s);
        }
        return s;
    }

    @Override
    public synchronized Session getStatelessSession(String contextName, String mappingName) throws G9DataAccessException {
        return this.openSession(this.getSessionFactory(contextName, mappingName), true);
    }

    @Override
    public synchronized Session cloneSession(Session session) throws IllegalArgumentException, G9DataAccessException {
        if (!(session instanceof HibernateSession)) {
            throw new IllegalArgumentException("Not supported for this Session implementation");
        }
        return this.openSession(((HibernateSession)session).getSession().getSessionFactory(), false);
    }

    @Override
    public synchronized void closeSession(Session s) throws G9DataAccessException {
        if (s != null) {
            for (ThreadLocal<Object> sessionHolder : this.sessionHolders.values()) {
                Session itSession = (Session)sessionHolder.get();
                if (itSession != s) continue;
                sessionHolder.set(null);
                break;
            }
            try {
                s.close();
            }
            catch (Exception e) {
                Object[] args = new Object[]{e.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9DataAccessException((Throwable)e, msg);
            }
        }
    }

    public synchronized Session switchSession(String contextName, String mappingName, Session newSession) {
        ThreadLocal<Object> sessionHolder = this.getSessionHolder(contextName, mappingName);
        Session oldSession = (Session)sessionHolder.get();
        sessionHolder.set(newSession);
        return oldSession;
    }

    public static synchronized SessionFactory getSessionfactory() {
        if (sessionFactory == null) {
            sessionFactory = new HibernateSessionFactory();
        }
        return sessionFactory;
    }

    private org.hibernate.SessionFactory getSessionFactory(String contextName, String mappingName) {
        String keyName = this.getMapKey(contextName, mappingName);
        org.hibernate.SessionFactory sf = this.sessionFactories.get(keyName);
        if (sf == null) {
            sf = this.createSessionFactory(contextName, mappingName);
            this.sessionFactories.put(keyName, sf);
        }
        return sf;
    }

    private ThreadLocal<Object> getSessionHolder(String contextName, String mappingName) {
        String keyName = this.getMapKey(contextName, mappingName);
        ThreadLocal<Object> sessionHolder = this.sessionHolders.get(keyName);
        if (sessionHolder == null) {
            sessionHolder = new ThreadLocal();
            this.sessionHolders.put(keyName, sessionHolder);
        }
        return sessionHolder;
    }

    private String getMapKey(String contextName, String mappingName) {
        return contextName == null || mappingName == null ? "" : contextName + mappingName;
    }

    private Session openSession(org.hibernate.SessionFactory sf, boolean stateless) throws G9DataAccessException {
        AbstractHibernateSession s = null;
        try {
            s = stateless ? new HibernateStatelessSession(sf.openStatelessSession()) : new HibernateSession(sf.openSession());
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9DataAccessException((Throwable)e, msg);
        }
        return s;
    }

    private org.hibernate.SessionFactory createSessionFactory(String contextName, String mappingName) throws G9DataAccessException {
        String propName;
        org.hibernate.SessionFactory factory = null;
        Configuration cfg = null;
        ServiceRegistry sr = null;
        Registry reg = Registry.getRegistry();
        String serverName = null;
        if (contextName != null && mappingName != null && (serverName = reg.getDatabaseContextProperty(contextName, propName = mappingName + "." + databaseServerSuffix)) == null) {
            serverName = reg.getDatabaseContextProperty(DEFAULT_CONTEXT, propName);
        }
        String propertiesBeanId = HibernateSessionFactory.getPropertiesBeanId(serverName);
        String resourcesBeanId = HibernateSessionFactory.getResourcesBeanId(serverName != null ? mappingName : null);
        HibernateProperties hibernateProperties = HibernateSessionFactory.getHibernateProperties(propertiesBeanId);
        HibernateResources hibernateResources = HibernateSessionFactory.getHibernateResources(resourcesBeanId);
        if (hibernateProperties != null && hibernateResources != null) {
            try {
                this.logger.trace((Object)("Creating a new SessionFactory using Spring[" + serverName + ", " + mappingName + "]"));
                cfg = HibernateSessionFactory.buildConfig(hibernateProperties, hibernateResources);
                sr = HibernateSessionFactory.buildServiceRegistry(cfg);
                factory = cfg.buildSessionFactory(sr);
            }
            catch (Exception e) {
                Message msg = MessageSystem.getMessageFactory().getMessage("-1201", new Object[]{e.getMessage()});
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9DataAccessException((Throwable)e, msg);
            }
        }
        if (factory == null) {
            String propertyFileName = null;
            String configFileName = null;
            if (serverName != null) {
                propertyFileName = reg.getDatabaseServerProperty(serverName, databasePropertiesSuffix);
                configFileName = reg.getDatabaseMappingProperty(mappingName, databaseConfigurationSuffix);
            }
            try {
                this.logger.trace((Object)("Creating a new SessionFactory using cfg.xml[" + propertyFileName + ", " + configFileName + "]"));
                cfg = HibernateSessionFactory.buildConfig(propertyFileName, configFileName);
                sr = HibernateSessionFactory.buildServiceRegistry(cfg);
                factory = cfg.buildSessionFactory(sr);
            }
            catch (Exception e) {
                Message msg = MessageSystem.getMessageFactory().getMessage("-1201", new Object[]{e.getMessage()});
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9DataAccessException((Throwable)e, msg);
            }
        }
        return factory;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static String getDatabaseConfigurationSuffix() {
        return databaseConfigurationSuffix;
    }

    public static void setDatabaseConfigurationSuffix(String databaseConfigurationSuffix) {
        HibernateSessionFactory.databaseConfigurationSuffix = databaseConfigurationSuffix;
    }

    public static String getDatabasePropertiesSuffix() {
        return databasePropertiesSuffix;
    }

    public static void setDatabasePropertiesSuffix(String databasePropertiesSuffix) {
        HibernateSessionFactory.databasePropertiesSuffix = databasePropertiesSuffix;
    }

    public static String getDatabaseServerSuffix() {
        return databaseServerSuffix;
    }

    public static void setDatabaseServerSuffix(String databaseServerSuffix) {
        HibernateSessionFactory.databaseServerSuffix = databaseServerSuffix;
    }

    static ServiceRegistry buildServiceRegistry(Configuration cfg) {
        return new StandardServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).build();
    }

    static Configuration buildConfig(HibernateProperties hibernateProperties, HibernateResources hibernateResources) {
        Properties props = hibernateProperties.buildProperties();
        Configuration cfg = new Configuration();
        cfg.addProperties(props);
        hibernateResources.addResourcesToConfiguration(cfg);
        return cfg;
    }

    static Configuration buildConfig(String propertyFileName, String configFileName) {
        Configuration cfg = new Configuration();
        Properties properties = null;
        if (propertyFileName != null && !"".equals(propertyFileName) && !hibernatePropertiesFile.equals(propertyFileName)) {
            properties = RegistrySet.loadProperties((String)propertyFileName, (boolean)true);
        }
        if (properties != null) {
            cfg.setProperties(properties);
        }
        if (configFileName != null) {
            cfg.configure(configFileName);
        } else {
            cfg.configure();
        }
        return cfg;
    }

    static HibernateProperties getHibernateProperties(String beanID) {
        HibernateProperties retVal = null;
        try {
            retVal = (HibernateProperties)G9Spring.getBean(HibernateProperties.class, (String)beanID);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return retVal;
    }

    static HibernateResources getHibernateResources(String beanID) {
        HibernateResources retVal = null;
        try {
            retVal = (HibernateResources)G9Spring.getBean(HibernateResources.class, (String)beanID);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return retVal;
    }

    static String getPropertiesBeanId(String serverName) {
        String propertyBeanId = null;
        propertyBeanId = serverName != null ? beanPrefix + "_" + serverName + "_" + databasePropertiesSuffix : beanPrefix + "_" + beanDefaultPart + "_" + databasePropertiesSuffix;
        return propertyBeanId;
    }

    static String getResourcesBeanId(String mappingName) {
        String resourceBeanId = null;
        resourceBeanId = mappingName != null ? beanPrefix + "_" + mappingName + "_" + databaseConfigurationSuffix : beanPrefix + "_" + beanDefaultPart + "_" + databaseConfigurationSuffix;
        return resourceBeanId;
    }

    static {
        databaseServerSuffix = "server";
        databasePropertiesSuffix = "properties";
        databaseConfigurationSuffix = "configuration";
        beanPrefix = "sessionFactory";
        beanDefaultPart = "default";
    }
}

