/*
 * Decompiled with CFR 0.152.
 */
package no.g9.dataaccess.usertype;

import java.io.Serializable;
import java.util.Properties;
import no.g9.dataaccess.usertype.ParameterizedType;

public class TextBoolean
implements ParameterizedType,
Serializable {
    private Boolean defaultValue = null;
    private String falseSaveValue = "N";
    private String trueSaveValue = "J";
    private String[] trueValues;

    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String paramValue = (String)parameters.get("default");
            if (paramValue != null && !paramValue.equals("null")) {
                this.defaultValue = new Boolean(paramValue);
            }
            if ((paramValue = (String)parameters.get("falseSaveValue")) != null) {
                this.falseSaveValue = paramValue;
            }
            if ((paramValue = (String)parameters.get("trueSaveValue")) != null) {
                this.trueSaveValue = paramValue;
            }
            if ((paramValue = (String)parameters.get("trueValues")) != null) {
                this.trueValues = paramValue.split(",");
                for (int i = 0; i < this.trueValues.length; ++i) {
                    this.trueValues[i] = this.trueValues[i].trim();
                }
            }
        }
    }

    public Boolean fromText(String value) {
        Boolean result = this.defaultValue;
        if (value != null) {
            result = Boolean.FALSE;
            for (int i = 0; i < this.trueValues.length; ++i) {
                if (!this.trueValues[i].equalsIgnoreCase(value.trim())) continue;
                result = Boolean.TRUE;
            }
        }
        return result;
    }

    public String fromBoolean(Boolean value) {
        if (value != null) {
            if (value.booleanValue()) {
                return this.trueSaveValue;
            }
            return this.falseSaveValue;
        }
        return null;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getFalseSaveValue() {
        return this.falseSaveValue;
    }

    public void setFalseSaveValue(String falseSaveValue) {
        this.falseSaveValue = falseSaveValue;
    }

    public String getTrueSaveValue() {
        return this.trueSaveValue;
    }

    public void setTrueSaveValue(String trueSaveValue) {
        this.trueSaveValue = trueSaveValue;
    }

    public String[] getTrueValues() {
        return (String[])this.trueValues.clone();
    }

    public void setTrueValues(String[] trueValues) {
        this.trueValues = (String[])trueValues.clone();
    }
}

