/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import no.g9.dataaccess.Session;
import no.g9.jgrape.Manager;
import no.g9.service.enumerator.ENavigation;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

public abstract class Role
implements Manager {
    private String name;
    private List<String> excludedAttributes;
    private List<String> includedAttributes;
    private Role parent;
    private List<Role> downRelated;
    private List<Role> upRelated;
    private List<Key> keys;
    private ObjectSelection currentObjectSelection = null;

    protected Key addKey(String keyName, boolean inOs, boolean isPrimaryKey) {
        Key key = new Key();
        key.keyName = keyName;
        key.inOs = inOs;
        key.isPrimaryKey = isPrimaryKey;
        key.attributes = new LinkedList<String>();
        this.keys.add(key);
        return key;
    }

    protected List<String> getKeyAttributes(String keyName) {
        List<String> result = null;
        if (keyName != null && this.keys != null) {
            for (Key key : this.keys) {
                if (!keyName.equals(key.keyName)) continue;
                result = key.attributes;
                break;
            }
        }
        return result;
    }

    protected String getPrimaryKey() {
        String result = null;
        if (this.keys != null) {
            for (Key key : this.keys) {
                if (!key.inOs || !key.isPrimaryKey) continue;
                result = key.keyName;
                break;
            }
        }
        return result;
    }

    protected String getMainKey() {
        String result = null;
        if (this.keys != null) {
            for (Key key : this.keys) {
                if (!key.inOs) continue;
                result = key.keyName;
                break;
            }
        }
        return result;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String aName) {
        this.name = aName;
    }

    protected List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    protected void setExcludedAttributes(List<String> aExcludedAttributes) {
        this.excludedAttributes = aExcludedAttributes;
    }

    protected List<String> getIncludedAttributes() {
        return this.includedAttributes;
    }

    protected void setIncludedAttributes(List<String> aIncludedAttributes) {
        this.includedAttributes = aIncludedAttributes;
    }

    protected List<Role> getDownRelated() {
        return this.downRelated;
    }

    protected void setDownRelated(List<Role> aDownRelated) {
        this.downRelated = aDownRelated;
    }

    protected List<Role> getUpRelated() {
        return this.upRelated;
    }

    protected void setUpRelated(List<Role> aUpRelated) {
        this.upRelated = aUpRelated;
    }

    public ObjectSelection getCurrentObjectSelection() {
        return this.currentObjectSelection;
    }

    public void setCurrentObjectSelection(ObjectSelection anObjectSelection) {
        this.currentObjectSelection = anObjectSelection;
    }

    protected Role getParent() {
        return this.parent;
    }

    protected void setParent(Role aParent) {
        this.parent = aParent;
    }

    public void initializeRole(String applicationName, String roleName, Role parentRole) {
        this.name = roleName;
        this.parent = parentRole;
        this.downRelated = new LinkedList<Role>();
        this.upRelated = new LinkedList<Role>();
        this.excludedAttributes = new LinkedList<String>();
        this.includedAttributes = new LinkedList<String>();
        this.keys = new LinkedList<Key>();
    }

    public Role findRole(String roleName) {
        Role role = null;
        if (roleName.equals(this.name)) {
            role = this;
        }
        if (this.downRelated != null) {
            ListIterator<Role> drIt = this.downRelated.listIterator();
            while (role == null && drIt.hasNext()) {
                role = ((Role)drIt.next()).findRole(roleName);
            }
        }
        if (this.upRelated != null) {
            ListIterator<Role> urIt = this.upRelated.listIterator();
            while (role == null && urIt.hasNext()) {
                role = ((Role)urIt.next()).findRole(roleName);
            }
        }
        return role;
    }

    @Override
    public abstract Object find(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract List<?> findAll(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object save(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object insert(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object update(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object delete(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object connect(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object disconnect(ObjectSelection var1, ClientContext var2, Session var3);

    @Override
    public abstract Object get(ObjectSelection var1, ENavigation var2, ClientContext var3, Session var4);

    @Override
    @Deprecated
    public void cleanupResult(Object rootResult) {
    }

    @Override
    @Deprecated
    public void cleanupResult(Object rootResult, ClientContext ctx) {
        this.cleanupResult(rootResult);
    }

    @Override
    public void cleanupResult(Object rootResult, ClientContext ctx, Session session) {
        this.cleanupResult(rootResult, ctx);
    }

    @Override
    public void cleanupResultAssociations(Object rootResult, ClientContext ctx, Session session) {
    }

    protected Role getRootRole() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootRole();
    }

    protected static class Key {
        String keyName;
        boolean inOs;
        boolean isPrimaryKey;
        List<String> attributes;

        protected Key() {
        }

        public void addAttribute(String attribute) {
            this.attributes.add(attribute);
        }
    }
}

