/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import no.esito.log.Logger;
import no.g9.jgrape.trigger.JGrapeTrigger;
import no.g9.jgrape.trigger.RegistryManager;
import no.g9.jgrape.trigger.TriggerFilter;
import no.g9.jgrape.trigger.TriggerProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class JGrapeTriggerProvider
implements TriggerProvider {
    private static final Logger log = Logger.getLogger(JGrapeTriggerProvider.class);
    private Map<Class<?>, List<JGrapeTrigger<?>>> cachedTriggers = new HashMap();
    @Autowired
    private RegistryManager registryManager;

    @Override
    public List<JGrapeTrigger<?>> getTrigger(Class<?> domainClass, JGrapeTrigger.TriggerType type) {
        log.info((Object)("Getting " + (Object)((Object)type) + " triggers for " + domainClass));
        List<JGrapeTrigger<?>> triggerList = this.cachedTriggers.get(domainClass);
        if (triggerList == null) {
            triggerList = this.createTriggerList(domainClass);
            this.cachedTriggers.put(domainClass, triggerList);
        }
        List<JGrapeTrigger<?>> filteredList = TriggerFilter.filter(triggerList, type);
        log.info((Object)("Found triggers are: " + filteredList));
        return filteredList;
    }

    private List<JGrapeTrigger<?>> createTriggerList(Class<?> domainClass) {
        log.debug((Object)("Creating trigger list for " + domainClass));
        ArrayList triggerList = new ArrayList();
        SuperClassIterator superClassTraverser = new SuperClassIterator(domainClass);
        if (log.isTraceEnabled()) {
            String msg = "Class list used for traversal is " + domainClass;
            log.trace((Object)msg);
            log.trace((Object)("superclasses are: " + superClassTraverser));
        }
        for (Class<?> clazz : superClassTraverser) {
            List<JGrapeTrigger<?>> interfaceList = this.buildInterfaceList(clazz);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Triggers for " + clazz + " interfaces are " + interfaceList));
            }
            triggerList.addAll(interfaceList);
            List<JGrapeTrigger<?>> superClassTriggers = this.registryManager.getTriggerList(clazz);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Triggers for superclass " + clazz + " are " + superClassTriggers));
            }
            triggerList.addAll(superClassTriggers);
        }
        return this.removeDuplicates(triggerList);
    }

    private List<JGrapeTrigger<?>> buildInterfaceList(Class<?> clazz) {
        ArrayList triggerList = new ArrayList();
        Class<?>[] localInterfaces = clazz.getInterfaces();
        ArrayList allSuperInterfaces = new ArrayList();
        for (Class<?> interfaze : localInterfaces) {
            allSuperInterfaces.addAll(this.getAllSuperInterfaces(interfaze));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found interfaces for " + clazz + " are " + allSuperInterfaces));
        }
        for (Class clazz2 : allSuperInterfaces) {
            List<JGrapeTrigger<?>> interfaceTriggers = this.registryManager.getTriggerList(clazz2);
            triggerList.addAll(interfaceTriggers);
        }
        return triggerList;
    }

    private List<JGrapeTrigger<?>> removeDuplicates(List<JGrapeTrigger<?>> list) {
        log.trace((Object)"Removing possible duplicates");
        HashSet foundTriggers = new HashSet();
        ArrayList noDuplicateList = new ArrayList();
        for (JGrapeTrigger<?> jGrapeTrigger : list) {
            if (!foundTriggers.contains(jGrapeTrigger)) {
                noDuplicateList.add(jGrapeTrigger);
            } else {
                log.trace((Object)("Trigger " + jGrapeTrigger + " is already found."));
            }
            foundTriggers.add(jGrapeTrigger);
        }
        return noDuplicateList;
    }

    private List<Class<?>> getAllSuperInterfaces(Class<?> interfaze) {
        assert (interfaze.isInterface());
        ArrayList interfaceList = new ArrayList();
        Class<?>[] interfaces = interfaze.getInterfaces();
        if (interfaces != null) {
            for (Class<?> parentInterfaze : interfaces) {
                interfaceList.addAll(this.getAllSuperInterfaces(parentInterfaze));
            }
        }
        interfaceList.add(interfaze);
        return interfaceList;
    }

    private static class SuperClassIterator
    implements Iterable<Class<?>> {
        private List<Class<?>> superClassList;

        SuperClassIterator(Class<?> clazz) {
            this.superClassList = this.buildList(clazz);
        }

        @Override
        public Iterator<Class<?>> iterator() {
            return this.superClassList.iterator();
        }

        public String toString() {
            return "SuperClassIterator [superClassList=" + this.superClassList + "]";
        }

        private List<Class<?>> buildList(Class<?> clazz) {
            log.trace((Object)("Building class list for " + clazz));
            if (Object.class.equals(clazz)) {
                ArrayList classList = new ArrayList();
                classList.add(clazz);
                return classList;
            }
            Class<?> superclass = clazz.getSuperclass();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Superclass of " + clazz + " is " + superclass));
            }
            List<Class<?>> classList = superclass != null ? this.buildList(superclass) : new ArrayList();
            classList.add(clazz);
            return classList;
        }
    }
}

