/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.trigger;

import java.util.Iterator;
import java.util.List;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.dataaccess.Session;
import no.g9.jgrape.trigger.JGrapeTrigger;
import no.g9.jgrape.trigger.TriggerProvider;
import no.g9.support.ClientContext;

public final class TriggerInvoker {
    private static Logger log = Logger.getLogger(TriggerInvoker.class);

    private TriggerInvoker() {
    }

    public static final <T> void invoke(T domainObject, JGrapeTrigger.TriggerType type, boolean isTargetNode, ClientContext ctx, Session session) {
        log.debug((Object)("Invoking " + (Object)((Object)type) + "triggers for " + domainObject));
        TriggerInvoker.nullCheck(domainObject, type);
        TriggerProvider provider = (TriggerProvider)ServiceLoader.getService(TriggerProvider.class);
        List<JGrapeTrigger<?>> trigger = provider.getTrigger(domainObject.getClass(), type);
        Iterator<JGrapeTrigger<?>> iterator = trigger.iterator();
        while (iterator.hasNext()) {
            JGrapeTrigger<?> unTyped;
            JGrapeTrigger<?> jGrapeTrigger = unTyped = iterator.next();
            jGrapeTrigger.trigger(domainObject, type, isTargetNode, ctx, session);
        }
    }

    private static void nullCheck(Object domainObject, JGrapeTrigger.TriggerType type) throws IllegalArgumentException {
        String errorMsg = null;
        if (domainObject == null) {
            errorMsg = "Domain object cannot be <code>null</code>";
        } else if (type == null) {
            errorMsg = "Trigger type cannot be <code>null</code>";
        }
        if (domainObject == null || type == null) {
            throw new IllegalArgumentException(errorMsg);
        }
    }
}

