/*
 * Decompiled with CFR 0.152.
 */
package no.g9.jgrape.tx;

import no.g9.dataaccess.HibernateSessionFactory;
import no.g9.dataaccess.Session;
import no.g9.dataaccess.SessionFactory;
import no.g9.jgrape.SessionManager;
import no.g9.jgrape.tx.TxCommand;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.ClientContext;

public class TxSessionManager
extends SessionManager {
    private Session oldSession;

    protected Session getSession(String contextName, String mappingName) {
        SessionFactory sf = SessionManager.getSessionFactory();
        if (sf instanceof HibernateSessionFactory) {
            this.oldSession = ((HibernateSessionFactory)sf).switchSession(contextName, mappingName, null);
        }
        return sf.getSession(contextName, mappingName);
    }

    protected void resetSession(String contextName, String mappingName) {
        SessionFactory sf = SessionManager.getSessionFactory();
        if (sf instanceof HibernateSessionFactory) {
            ((HibernateSessionFactory)sf).switchSession(contextName, mappingName, this.oldSession);
        }
    }

    protected void runTx(Session session, ClientContext clientContext, TxCommand command) {
        try {
            session.beginTransaction();
            command.execute(clientContext, session);
            session.commitTransaction();
        }
        catch (RuntimeException e) {
            if (session.canRollbackTransaction()) {
                try {
                    session.rollbackTransaction();
                }
                catch (RuntimeException bad) {
                    this.logExceptionQuietly(bad);
                }
            }
            throw e;
        }
        finally {
            try {
                SessionManager.getSessionFactory().closeSession(session);
            }
            catch (Exception bad) {
                this.logExceptionQuietly(bad);
            }
        }
    }

    protected void logExceptionQuietly(Exception bad) {
        Object[] args = new Object[]{bad.getMessage()};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1201", args);
        msg.setException((Throwable)bad);
        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
    }
}

