/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import no.g9.client.core.action.EventContext;

/**
 * Action method wraps the invocation of a method.
 */
public abstract class ActionMethod implements Runnable {

    private EventContext event;

    /**
     * Get the event that triggered the action.
     * @return the action event
     */
    public EventContext getEvent() {
        return event;
    }

    /**
     * Set the event that triggered the action.
     * @param event action event
     */
    public void setEvent(EventContext event) {
        this.event = event;
    }

}
