/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import no.g9.client.core.action.HookInvoker;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.ApplicationController;

/**
 * The default hook invoker which always invokes the hook on the current thread.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class DefaultHookInvoker implements HookInvoker {

    /** The delegate executor service */
    @Override
    public <T> T execute(ApplicationController appCtrl, ThreadType threadType,
            final HookMethod<T> hookMethodInvokation) throws Exception {
        return hookMethodInvokation.call();
    }

}