/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

/**
 * GUI method wrapper.
 */
public abstract class GuiTask implements Runnable {
    private final String guiMethod;
    
    /**
     * @param methodName - the method to run
     */
    public GuiTask(String methodName) {
        guiMethod = methodName;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return guiMethod;
    }
}
