/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import java.util.List;

import no.g9.client.core.action.DialogInteraction;
import no.g9.client.core.controller.DialogConstant;

/**
 * The default implementation of the HookProvider interface
 *
 */
public interface HookProvider {


    /**
     * @param caller dialog
     * @return list of hooks
     */
    List<DialogInteraction> getCallerInteractionHook(DialogConstant caller);

    /**
     * @param callee dialog
     * @return list of hooks
     */
    List<DialogInteraction> getCalleeInteractionHook(DialogConstant callee);

}