/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import no.esito.jvine.controller.JVineAppController;
import no.esito.log.Logger;
import no.g9.client.core.action.HookInvoker;
import no.g9.client.core.action.ThreadType;
import no.g9.client.core.controller.ApplicationController;

/**
 * A hook invoker capable of switching from a worker thread to a JSF thread.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class JSFHookInvoker implements HookInvoker {

    private static final Logger log = Logger.getLogger(JSFHookInvoker.class); 
    
    @Override
    public <T> T execute(ApplicationController appCtrl, ThreadType threadType,
            HookMethod<T> hookMethodInvokation) throws Exception {

        if (!ThreadManager.isWorkerThread()) {
            String msg = "Trying to execute hook invocation on wrong thread: "
                    + Thread.currentThread().getName();
            throw new IllegalStateException(msg);
        }

        if (threadType == ThreadType.GUI) {
            if (log.isTraceEnabled()) {
                log.trace("Invoking " + hookMethodInvokation + " on gui thread");
            }
            JVineAppController ctrl = JVineAppController.getInstance(appCtrl);
            return ctrl.getActionQueue().perform(hookMethodInvokation);
        }

        if (log.isTraceEnabled()) {
            log.trace("Invoking " + hookMethodInvokation + " on worker thread");
        }
        
        return hookMethodInvokation.call();

    }

}

