/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import no.esito.log.Logger;
import no.g9.client.core.action.ActionExecutor;
import no.g9.client.core.action.G9Action;

/**
 * The action executor. Executes actions one by one on a single, dedicated
 * thread by using an ExecutorService delegate.
 * <p>
 * <strong>OBS:</strong> Remember to shut down this executor!
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class SingleThreadedActionExecutor implements ActionExecutor {

    /** The logger */
    private static Logger log = Logger
            .getLogger(SingleThreadedActionExecutor.class);

    /**
     * The delegate executor service that executes the actions.
     */
    private ExecutorService delegate = Executors.newSingleThreadExecutor();

    @Override
    public void execute(G9Action<?> action) {
        log.info("Submitting " + action);
        delegate.submit(action);
    }

    @Override
    public void shutDown() {
        delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return delegate.shutdownNow();
    }

}
