/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.communication;

import no.g9.client.core.communication.G9ActionPayload;
import no.g9.client.core.communication.SystemMessage;

/**
 * Used to compile actionmessages and then send them.
 *
 */
public class ActionMessageCompilation {
    private SystemMessage message;
    /**
     * @return the message.
     */
    public SystemMessage getMessage() {
        return message;
    }

    /**
     * @param message the message.
     */
    public void setMessage(SystemMessage message) {
        this.message = message;
    }

    /**
     * @return the action payload.
     */
    public G9ActionPayload getG9ActionPayload() {
        return g9ActionPayload;
    }

    /**
     * @param g9ActionPayload the action payload.
     */
    public void setG9ActionPayload(G9ActionPayload g9ActionPayload) {
        this.g9ActionPayload = g9ActionPayload;
    }

    private G9ActionPayload g9ActionPayload;
    private SystemMessagePipe pipe;
    
    /**
     * Creates compilation.
     * @param pipe the pipe which will receive the finished message;
     */
    public ActionMessageCompilation(SystemMessagePipe pipe){
        this.pipe=pipe;
    }
    
    /**
     * Creates compilation.
     * @param message the message.
     * @param g9ActionPayload the g9ActionPayload.
     * @param pipe the pipe.
     */
    public ActionMessageCompilation(SystemMessage message,
            G9ActionPayload g9ActionPayload,
            SystemMessagePipe pipe) {
        this.pipe=pipe;
        this.message = message;
        this.g9ActionPayload = g9ActionPayload;
    }

    /**
     * Forward the message. Sets all fields to null.
     */
    public void forward(){
        if(message==null)
            throw new IllegalArgumentException("The message can't be null");
        if(g9ActionPayload==null)
            throw new IllegalArgumentException("The g9ActionPayload can't be null");
        
        pipe.forward(message.payload(g9ActionPayload.code()));
        message=null;
        g9ActionPayload=null;        
    }
}
