/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import no.esito.jvine.action.ActionQueue;

/**
 * This is the "privileged" part of the application controller, which delegates 
 * all methods to the actual application controller's package-visibility methods.
 * Instances of this class are intended for create-and-throw away use --- create
 * an instance when needed and throw it away when you don't want it any more.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public abstract class JVineAppController {
    
    private final JVineApplicationController delegate;
    
    /**
     * Get a JVineAppController instance that gives access to the "privileged" part
     * of the specified application controller. 
     * @param delegate the application controller to wrap with this jVine app controller.
     * @return the JVineAppController for the specified application controller.
     */
    public static final JVineAppController getInstance(JVineApplicationController delegate) {
        return new JVineAppController(delegate) {
            // empty
        };
    }

    private JVineAppController(JVineApplicationController delegate) { 
        this.delegate = delegate;
    }
    
    
    /**
     * Gets the application's action queue.
     * @return the action queue.
     */
    public ActionQueue getActionQueue() {
        return delegate.getActionQueue();
    }
    
    /**
     * Get the invokeHooks flag used to determine whether actions should invoke
     * registered hooks or not. If this flag is set to true, action hooks are
     * invoked, otherwise action hooks are ignored.
     * 
     * @return <code>true</code> if action hooks should be invoked.
     */
    public boolean isInvokeHooksOn() {
        return delegate.isInvokeHooksOn();
    }

    /**
     * Set the invoke hooks flag used to determine whether actions should invoke
     * registered hooks or not. 
     * @param invokeHooks the invoke hooks property.
     * @see #isInvokeHooksOn()
     */
    public void setInvokeHooks(boolean invokeHooks) {
        delegate.setInvokeHooks(invokeHooks);
    }
}
