/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import no.esito.jvine.action.ActionMethod;
import no.esito.jvine.action.ActionMethodRunner;
import no.esito.jvine.model.TreeNode;
import no.g9.client.core.action.ActionFactory;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.EventContext;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.message.BlockingMessageCallback;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ViewModel;
import no.g9.exception.G9ClientException;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;
import no.g9.support.ObjectSelection;
import no.g9.support.action.ActionTarget;
import no.g9.support.convert.ConvertException;

/**
 * The dialog controller interface used by the frame work and generated classes.
 * <p>
 * <strong>WARNING:</strong> Although this interface is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public interface JVineDialogController extends DialogStateHandler,
        EventDispatcher {

    /**
     * Get the view's field data for the specified role.
     *
     * @param roleConstant
     *            the constant denoting the role.
     * @return the field data of that role.
     */
    FieldData getFieldData(RoleConstant roleConstant);

    /**
     * Get the ViewModel for the this dialog.
     *
     * @return the ViewModel for this dialog.
     */
    ViewModel getViewModel();

    /**
     * Get the task that will obtain the specified target node.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @param target
     *            the target node
     * @param actionType the action type for this obtain
     * @return the task that will obtain the specified target node
     */
    ActionTask<ObjectSelection> getObtainDialogTask(ActionTarget target, ActionType actionType);

    /**
     * Gets the action task that recursively displays on a node.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @param target the target node
     * @param actionType the action type for this display
     * @return an action task capable of displaying from the target node
     */
    ActionTask<Void> getDisplayDialogTask(ActionTarget target, ActionType actionType);

    /**
     * Returns the one related children of the specified role.
     ** <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @param role
     *            the role to get the one related children from.
     * @return the role's one-related children.
     */
    Collection<OSNode<?>> getOneRelatedChildren(RoleConstant role);

    /**
     * Close the dialog. First, the dialog proxy is cleared of all instances.
     * Then each root node is cleared (recursively clearing the whole
     * structure). Then the action method runner is shut-down. *
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     */
    void closeDialogController();

    /**
     * Get the action method runner belonging to this controller.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be
     * treated as part of the public API available to the application
     * programmer, as it might change in incompatible ways between releases
     * (even patches).
     *
     * @return the action method runner of this dialog controller.
     */
    ActionMethodRunner getActionMethodRunner();

    /**
     * Returns a message callback that can be used for synchronizing message
     * interaction.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @return a message callback.
     */
    BlockingMessageCallback getMessageCallback();

    /**
     * Gets the specified action.
     ** <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @param <T>
     *            the result class of invoking this action.
     * @param actionType
     *            the action type
     * @param target
     *            the action target
     * @param actionTask
     *            the callable action task
     * @param targetType
     *            the target class
     * @return the g9 action
     */
    <T> G9Action<T> getAction(ActionType actionType, ActionTarget target,
            Class<T> targetType, ActionTask<T> actionTask);

    /**
     * Sets the action method runner of this dialog controller.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @param actionMethodRunner
     *            the action method runner to set.
     */
    void setActionMethodRunner(ActionMethodRunner actionMethodRunner);

    @Override
    void dispatch(EventContext event);

    @Override
    void registerView(final DialogView dialogView);

    @Override
    <T> Collection<T> getAllInstances(OSNode<T> role);

    @Override
    boolean isCurrent(Object inst, OSNode<?> role);

    /**
     * Adds an OSNode to this control.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be
     * treated as part of the public API available to the application
     * programmer, as it might change in incompatible ways between releases
     * (even patches).
     *
     * @param node
     *            the OSNode to add.
     */
    void addOSNode(OSNode<?> node);

    /**
     * Get the tree node sentinel for this dialog.
     *
     * @return the dialog's sentinel tree node.
     */
    TreeNode<?> getSentinel();

    @Override
    void addValidationResult(ValidationResult validationResult);

    @Override
    void addConverterException(ConvertException converterException);

    /**
     * Check that both validation and conversion has succeeded. Throws an
     * exception if not.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be
     * treated as part of the public API available to the application
     * programmer, as it might change in incompatible ways between releases
     * (even patches).
     *
     * @param isObtain
     *            set this to true if the action is an obtain, false if it is
     *            display.
     * @throws G9ClientException
     *             if at least one validator or converter has failed.
     */
    void checkValidationAndConvert(boolean isObtain)
            throws G9ClientException;

    /**
     * Gets the list of validation results.
     *
     * @return the validationResult
     */
    List<ValidationResult> getValidationResult();

    @Override
    void clearCurrent(RoleConstant role);

    /**
     * Gets the OSNode that represents the specified role.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be
     * treated as part of the public API available to the application
     * programmer, as it might change in incompatible ways between releases
     * (even patches).
     *
     * @param <T>
     *            The domain type represented by the object selection node.
     *
     * @param role
     *            constant denoting the role
     * @return the OSNode representing the specified role.
     */
    <T> OSNode<T> getOSNode(RoleConstant role);

    /**
     * Reports changed nodes to the view.
     ** <p>
     * <em>WARNING:<em>Although this method is protected, it should not be
     * treated as part of the public API available to the application
     * programmer, as it might change in incompatible ways between releases
     * (even patches).
     *
     * @param changedNodes
     *            collection of all changed nodes.
     * @param includeNodes
     *            collection of extra nodes to include.
     * @param excludeNode
     *            collection of nodes to exclude.
     */
    void reportToView(Collection<OSNode<?>> changedNodes,
            Collection<OSNode<?>> includeNodes, OSNode<?> excludeNode);

    /**
     * Gets an array of all root nodes.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     **
     * @return an array with all root nodes.
     */
    OSNode<?>[] getRootNodes();

    /**
     * Performs check close on this dialog.
     ** <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @return <code>true</code> if it close dialog should continue.
     */
    boolean checkClose();

    /**
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated
     * as part of the public API available to the application programmer, as it
     * might change in incompatible ways between releases (even patches).
     *
     * @return the map of root nodes.
     */
    Map<RoleConstant, OSNode<?>> getRoots();

    @Override
    void setCurrent(FieldData instanceFieldData);

    /**
     * Registers an event method. The <code>eventMethodInvoker</code> is a
     * runnable whose purpose is to invoke the actual even method.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be treated as
     * part of the public API available to the application programmer, as it might change in
     * incompatible ways between releases (even patches).
     * *
     *
     * @param eventMethodName
     *            the name of the event method
     * @param eventMethodInvoker
     *            the runnable that invokes the event method.
     */
    void registerEventMethod(String eventMethodName,
            ActionMethod eventMethodInvoker);

    /**
     * Get the dialog's action factory.
     * <p>
     * <em>WARNING:<em>Although this method is protected, it should not be treated as
     * part of the public API available to the application programmer, as it might change in
     * incompatible ways between releases (even patches).
     * *
     *
     * @return the dialog's actionFactory
     */
    ActionFactory getActionFactory();

    /**
     * Gets the action task that will perform a dialog check.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated as
     * part of the public API available to the application programmer, as it might change in
     * incompatible ways between releases (even patches).
     **
     * @param checkType
     *            the check type
     * @param target
     *            the target to check
     * @return the task that will perform the check
     */
    ActionTask<Boolean> getCheckDialogTask(ActionType checkType, ActionTarget target);

    /**
     * Get the dialog key for the dialog. The dialog key can be used to wrap the
     * dialog constant in an object that can be claimed by the garbage collector
     * (the dialog constant is an enum and cannot be claimed).
     *
     * @return the dialog key.
     */
    DialogKey getDialogKey();

}