/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import no.esito.jvine.view.AbstractApplicationView;
import no.esito.util.BeanID;
import no.g9.client.core.controller.ApplicationController;
import no.g9.message.DispatcherContext;
import no.g9.message.DispatcherContextProvider;

/**
 * Dispatcher context provider used by jVine.
 */
@BeanID("dispatcherContextProvider")
public class JVineDispatcherContextProvider implements DispatcherContextProvider {

	@Override
	public DispatcherContext getDispatcherContext() {
		ApplicationController applicationController = JVineApplicationController.getCurrentApplicationController();
		if (applicationController != null) {
			AbstractApplicationView applicationView = (AbstractApplicationView) applicationController.getApplicationView();
			return applicationView.getDispatcherContext();
		}
		return null;
	}

}
