/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.model;

import no.g9.os.RoleConstant;

/**
 * Keeps a role and the role's current object.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class CurrentRoleObject {

    
    private final RoleConstant role;
    private final Object current;
    

    /**
     * Constructs a new Current Role Object.
     * @param role the role of the current object.
     * @param current the current object.
     */
    public CurrentRoleObject(RoleConstant role, Object current) {
        this.role = role;
        this.current = current;
    }


    /**
     * Returns the role of this current role object.
     * @return the current role.
     */
    public final RoleConstant getRole() {
        return role;
    }


    /**
     * Returns the current object of this role.
     * @return the current object.
     */
    public final Object getCurrent() {
        return current;
    }


    @Override
    public String toString() {
        return "Current of " + role + " " + current;
    }
    
    
}
